local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local matched = false

    local function addStats()
        local function fmt(n, d) return InspectUI_fmtNumber(n, d or 1) end

        local w = statMap["weight"]
        if w then
            InspectDescription.addFormatted(
                b,
                "IGUI_Inspect_Mat_Stat_Weight", "Weight: %s units.",
                fmt(w.value or w.raw, 2)
            )
        end

        local c = statMap["condition"]
        if c then
            InspectDescription.addFormatted(
                b,
                "IGUI_Inspect_Mat_Stat_Condition", "Condition: %s%%.",
                fmt(c.value or c.raw, 0)
            )
        end

        local uses = statMap["usesLeft"]
        if uses then
            InspectDescription.addFormatted(
                b,
                "IGUI_Inspect_Mat_Stat_Uses", "Remaining uses: %s.",
                fmt(uses.value or uses.raw, 0)
            )
        end

        local fuel = statMap["fuelCapacity"]
        if fuel then
            InspectDescription.addFormatted(
                b,
                "IGUI_Inspect_Mat_Stat_Fuel", "Fuel capacity: %s units.",
                fmt(fuel.value or fuel.raw, 2)
            )
        end
    end

    --------------------------------------------------------
    -- MATERIALS COMPOSITES
    --------------------------------------------------------
    if child == "CraftingMaterial" then
        InspectDescription.addLine(b, InspectUI_tr("IGUI_Inspect_Mat_Crafting_Base",
            "Material used for crafting, repairing, or assembling items."))
        matched = true
    elseif child == "WoodMaterial" then
        InspectDescription.addLine(b, InspectUI_tr("IGUI_Inspect_Mat_Wood_Base",
            "Piece of wood suitable for construction, barricading, or crafting."))
        matched = true
    elseif child == "MetalMaterial" then
        InspectDescription.addLine(b, InspectUI_tr("IGUI_Inspect_Mat_Metal_Base",
            "Metal material intended for reinforced crafting or repairs."))
        matched = true
    elseif child == "FabricMaterial" then
        InspectDescription.addLine(b, InspectUI_tr("IGUI_Inspect_Mat_Fabric_Base",
            "Fabric used for tailoring, patching, or crafting."))
        matched = true
    elseif child == "ToolHead" then
        InspectDescription.addLine(b, InspectUI_tr("IGUI_Inspect_Mat_ToolHead_Base",
            "Tool head component intended for assembling functional tools."))
        matched = true
    elseif child == "Wallpaper" then
        InspectDescription.addLine(b, InspectUI_tr("IGUI_Inspect_Mat_Wallpaper_Base",
            "Wallpaper material used for decoration or surface covering."))
        matched = true
    elseif child == "WorldItem" then
        InspectDescription.addLine(b, InspectUI_tr("IGUI_Inspect_Mat_WorldItem_Base",
            "World material with limited crafting or utility value."))
        matched = true
    elseif child == "MiscUtility" then
        InspectDescription.addLine(b, InspectUI_tr("IGUI_Inspect_Mat_Misc_Base",
            "Miscellaneous crafting item with general utility."))
        matched = true
    elseif child == "BookItem" then
        InspectDescription.addLine(b, InspectUI_tr("IGUI_Inspect_Mat_BookItem_Base",
            "Document or note related to crafting, reference, or labeling."))
        matched = true
    end


    --------------------------------------------------------
    -- CHEMICALS / FUEL
    --------------------------------------------------------
    if child == "Chemical" then
        InspectDescription.addLine(b, InspectUI_tr("IGUI_Inspect_Mat_Chemical_Base",
            "Chemical substance used in cleaning, farming, or crafting processes."))
        matched = true
    elseif child == "Fuel" then
        InspectDescription.addLine(b, InspectUI_tr("IGUI_Inspect_Mat_Fuel_Base",
            "Fuel material used to power devices, tools, or vehicles."))
        matched = true
    end


    --------------------------------------------------------
    -- ELEMENTAL MATERIALS
    --------------------------------------------------------
    local elementalMap = {
        Aluminium = {
            key = "IGUI_Inspect_Mat_Aluminium_Base",
            default = "Lightweight aluminium material used in general crafting and repairs.",
        },
        Bone = {
            key = "IGUI_Inspect_Mat_Bone_Base",
            default = "Bone material used in primitive crafting or toolmaking.",
        },
        Brass = {
            key = "IGUI_Inspect_Mat_Brass_Base",
            default = "Brass material used for mechanical or decorative crafting.",
        },
        Charcoal = {
            key = "IGUI_Inspect_Mat_Charcoal_Base",
            default = "Charcoal used as fuel or as a component in crafting mixtures.",
        },
        Clay = {
            key = "IGUI_Inspect_Mat_Clay_Base",
            default = "Clay material used in pottery, crafting, or mold-making.",
        },
        Copper = {
            key = "IGUI_Inspect_Mat_Copper_Base",
            default = "Copper material used in crafting or basic electrical applications.",
        },
        Cotton = {
            key = "IGUI_Inspect_Mat_Cotton_Base",
            default = "Cotton fibers used in tailoring or light crafting.",
        },
        Fibre = {
            key = "IGUI_Inspect_Mat_Fibre_Base",
            default = "Natural or synthetic fiber material used in crafting.",
        },
        Glass = {
            key = "IGUI_Inspect_Mat_Glass_Base",
            default = "Glass shards or pieces used in crafting or repairs.",
        },
        Gold = {
            key = "IGUI_Inspect_Mat_Gold_Base",
            default = "Gold material used in decorative crafting.",
        },
        Iron = {
            key = "IGUI_Inspect_Mat_Iron_Base",
            default = "Iron material used for forging, repair, or structural crafting.",
        },
        Leather = {
            key = "IGUI_Inspect_Mat_Leather_Base",
            default = "Leather material used for tailoring or tool crafting.",
        },
        Silver = {
            key = "IGUI_Inspect_Mat_Silver_Base",
            default = "Silver material used in decorative or specialized crafting.",
        },
        Steel = {
            key = "IGUI_Inspect_Mat_Steel_Base",
            default = "Steel material used for durable crafting and reinforced repairs.",
        },
    }

    for key, entry in pairs(elementalMap) do
        if child == key then
            InspectDescription.addLine(b,
                InspectUI_tr(entry.key, entry.default))
            matched = true
            break
        end
    end


    --------------------------------------------------------
    -- FALLBACK
    --------------------------------------------------------
    if not matched then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Mat_Fallback",
                "Material with basic crafting potential."))
    end


    --------------------------------------------------------
    -- STATS
    --------------------------------------------------------
    addStats()


    --------------------------------------------------------
    -- PLUGINS
    --------------------------------------------------------
    local extra =
        InspectPlugins.appendMaterialLines and
        InspectPlugins.appendMaterialLines(item, statMap, child, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        else
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end

    return InspectDescription.finish(b)
end

return M
