local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()

    --------------------------------------------------------
    -- 1) Base description
    --------------------------------------------------------
    if child == "Magazine" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Mag_Base",
                "A detachable magazine used to store and feed ammunition into compatible firearms.")
        )

    elseif child == "AmmoBox" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_AmmoBox_Base",
                "A factory-sealed box containing multiple rounds of ammunition.")
        )

    elseif child == "AmmoCarton" or child == "Carton" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_AmmoCarton_Base",
                "A carton containing several ammunition boxes.")
        )

    elseif child == "LooseRound" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_LooseRound_Base",
                "A stack of loose ammunition rounds.")
        )

    else
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_AmmoContainer_Fallback",
                "An ammunition container.")
        )
    end


    --------------------------------------------------------
    -- 2) COUNT / CAPACITY / AMMO TYPE
    --------------------------------------------------------

    -- COUNT
    local count = statMap["count"] or statMap["amount"]
    if count then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Mag_Stat_Count",
            "Contains %s rounds.",
            tostring(count.value or count.raw)
        )
    end

    -- CAPACITY
    local cap = statMap["capacity"]
    if cap then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Mag_Stat_Capacity",
            "Capacity: %s rounds.",
            tostring(cap.value or cap.raw)
        )
    end

    -- AMMO TYPE
    local ammoType = statMap["ammoType"]
    if ammoType then
        local ammoName = tostring(ammoType.value or ammoType.raw)
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Mag_Stat_AmmoType",
            "Compatible with %s ammunition.",
            ammoName
        )
    end


    --------------------------------------------------------
    -- 3) PLUGINS
    --------------------------------------------------------
    local extra = InspectPlugins.appendMagazineLines
        and InspectPlugins.appendMagazineLines(item, statMap, child, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        elseif type(extra) == "table" then
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end


    --------------------------------------------------------
    -- 4) FINISH
    --------------------------------------------------------
    return InspectDescription.finish(b)
end

return M
