local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local subtype = child

    --------------------------------------------------------
    -- 1) BASE DESCRIPTION POR SUBCATEGORÍA
    --------------------------------------------------------
    if subtype == "Pistol" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Firearm_Base_Pistol",
                "A semi-automatic pistol designed for close-range engagements.")
        )

    elseif subtype == "Revolver" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Firearm_Base_Revolver",
                "A reliable revolver with a simple mechanical action.")
        )

    elseif subtype == "SMG" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Firearm_Base_SMG",
                "A lightweight submachine gun built for rapid close-to-mid range fire.")
        )

    elseif subtype == "Shotgun" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Firearm_Base_Shotgun",
                "A shotgun delivering high-damage pellet spread at close range.")
        )

    elseif subtype == "Rifle" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Firearm_Base_Rifle",
                "A rifle offering improved range and precision over handguns.")
        )

    elseif subtype == "AssaultRifle" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Firearm_Base_AssaultRifle",
                "An assault rifle capable of sustained fire at medium-to-long range.")
        )

    elseif subtype == "Sniper" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Firearm_Base_Sniper",
                "A precision rifle optimized for long-range accuracy.")
        )

    elseif subtype == "Improvised" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Firearm_Base_Improvised",
                "An improvised firearm with limited reliability and performance.")
        )

    else
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Firearm_Base_Fallback",
                "A firearm designed for ranged combat.")
        )
    end


    --------------------------------------------------------
    -- 2) STATS DEL ARMA (uno por línea)
    --------------------------------------------------------
    local function fmt(n, d)
        return InspectUI_fmtNumber(n, d or 1)
    end

    -- DAMAGE
    local dmg = statMap["damage"]
    if dmg then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_Damage",
            "Deals around %s damage.",
            fmt(dmg.value or dmg.raw, 1)
        )
    end

    -- RANGE
    local rng = statMap["range"]
    if rng then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_Range",
            "Has an effective range of about %s meters.",
            fmt(rng.value or rng.raw, 1)
        )
    end

    -- ACCURACY / SPREAD
    local acc = statMap["accuracy"]
    if acc then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_Accuracy",
            "Offers an accuracy rating of %s.",
            fmt(acc.value or acc.raw, 1)
        )
    end

    local spread = statMap["spread"]
    if spread then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_Spread",
            "Has a bullet spread value of %s.",
            fmt(spread.value or spread.raw, 2)
        )
    end

    -- NOISE
    local noise = statMap["noise"] or statMap["noiseRadius"]
    if noise then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_Noise",
            "Produces a noise level of %s.",
            fmt(noise.value or noise.raw, 1)
        )
    end

    -- RECOIL
    local recoil = statMap["recoil"]
    if recoil then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_Recoil",
            "Generates a recoil intensity of %s.",
            fmt(recoil.value or recoil.raw, 2)
        )
    end

    -- FIRE MODES
    local mode = statMap["fireMode"]
    if mode then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_FireMode",
            "Supports the %s fire mode.",
            tostring(mode.value or mode.raw)
        )
    end

    -- MAGAZINE SIZE
    local mag = statMap["magazineSize"]
    if mag then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_Magazine",
            "Holds up to %s rounds per magazine.",
            fmt(mag.value or mag.raw, 0)
        )
    end

    -- RELOAD TIME
    local reload = statMap["reloadTime"]
    if reload then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_Reload",
            "Requires around %s seconds to reload.",
            fmt(reload.value or reload.raw, 2)
        )
    end

    -- AIM TIME
    local aim = statMap["aimTime"]
    if aim then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_Aim",
            "Takes approximately %s seconds to aim.",
            fmt(aim.value or aim.raw, 2)
        )
    end

    -- CONDITION
    local cond = statMap["condition"]
    if cond then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_Condition",
            "Condition: %s.",
            fmt(cond.value or cond.raw, 0)
        )
    end

    -- WEIGHT
    local weight = statMap["weight"]
    if weight then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Firearm_Stat_Weight",
            "Weighs approximately %s units.",
            fmt(weight.value or weight.raw, 2)
        )
    end

    --------------------------------------------------------
    -- 3) PLUGIN SUPPORT
    --------------------------------------------------------
    local extra = InspectPlugins.appendFirearmLines
        and InspectPlugins.appendFirearmLines(item, statMap, subtype, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        elseif type(extra) == "table" then
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end

    --------------------------------------------------------
    -- 4) FINALIZAR
    --------------------------------------------------------
    return InspectDescription.finish(b)
end

return M
