local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local subtype = child

    --------------------------------------------------------
    -- 1) BASE DESCRIPTION
    --------------------------------------------------------
    if subtype == "Box" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Box",
                "Small storage box designed to hold lightweight items.")
        )

    elseif subtype == "Container" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Container",
                "General-purpose container with usable internal capacity.")
        )

    elseif subtype == "HouseholdContainer" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_HouseholdContainer",
                "Household container intended for simple storage tasks.")
        )

    elseif subtype == "Toolbox" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Toolbox",
                "Toolbox providing compartmentalized space for tools and components.")
        )

    elseif subtype == "Wallet" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Wallet",
                "Compact wallet designed to hold documents and small valuables.")
        )

    elseif subtype == "Keyring" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Keyring",
                "Keyring used to organize and secure multiple keys.")
        )

    elseif subtype == "Backpack" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Backpack",
                "Backpack designed to distribute weight and carry equipment safely.")
        )

    elseif subtype == "Belt" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Belt",
                "Utility belt offering additional attachment points for gear.")
        )

    elseif subtype == "Pouch" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Pouch",
                "Small pouch providing quick access to compact items.")
        )

    elseif subtype == "CampingGear" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_CampingGear",
                "Camping equipment intended for outdoor support and survival tasks.")
        )

    elseif subtype == "SleepingBag" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_SleepingBag",
                "Sleeping bag providing insulated comfort for rest.")
        )

    elseif subtype == "Tent" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Tent",
                "Lightweight tent designed for temporary outdoor shelter.")
        )

    elseif subtype == "Trapping" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Trapping",
                "Trapping device intended for small-game capture.")
        )

    elseif subtype == "Fishing" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Fishing",
                "Fishing tool designed to assist in aquatic resource gathering.")
        )

    elseif subtype == "Sports" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Sports",
                "Sports equipment intended for recreational physical activity.")
        )

    elseif subtype == "CookingTool" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_CookingTool",
                "Cooking tool designed for food preparation tasks.")
        )

    elseif subtype == "GardeningTool" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_GardeningTool",
                "Gardening tool intended for basic outdoor maintenance.")
        )

    elseif subtype == "InstrumentTool" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_InstrumentTool",
                "Musical instrument intended for sound production and practice.")
        )

    elseif subtype == "Toy" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Toy",
                "Toy item designed for entertainment or distraction.")
        )

    elseif subtype == "Paint" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Paint",
                "Paint or spray can designed for marking or decorative tasks.")
        )

    elseif subtype == "Instrument" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Instrument",
                "Musical instrument designed for performance or practice.")
        )

    elseif subtype == "VehiclePart" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_VehiclePart",
                "Vehicle component intended for maintenance or replacement.")
        )
    elseif subtype == "Security" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Security",
                "Security item intended to manage access (keys, locks, or related gear).")
        )

    else
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Equipment_Base_Fallback",
                "General-purpose equipment item with basic utility.")
        )
    end

    --------------------------------------------------------
    -- 2) STATS
    --------------------------------------------------------
    local function fmt(n, d)
        return InspectUI_fmtNumber(n, d or 1)
    end

    local cap = statMap["capacity"]
    if cap then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Equipment_Stat_Capacity",
            "Storage capacity: %s units.",
            fmt(cap.value or cap.raw, 2)
        )
    end

    local w = statMap["weight"]
    if w then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Equipment_Stat_Weight",
            "Weight: %s units.",
            fmt(w.value or w.raw, 2)
        )
    end

    local cond = statMap["condition"]
    if cond then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Equipment_Stat_Condition",
            "Condition: %s%%.",
            fmt(cond.value or cond.raw, 0)
        )
    end

    local uses = statMap["usesLeft"]
    if uses then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Equipment_Stat_UsesLeft",
            "Remaining uses: %s.",
            fmt(uses.value or uses.raw, 0)
        )
    end

    local water = statMap["waterCapacity"]
    if water then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Equipment_Stat_WaterCapacity",
            "Water capacity: %s units.",
            fmt(water.value or water.raw, 2)
        )
    end

    local liters = statMap["liters"]
    if liters then
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Equipment_Stat_Liters",
            "Liquid capacity: %s liters.",
            fmt(liters.value or liters.raw, 2)
        )
    end

    --------------------------------------------------------
    -- 3) PLUGINS
    --------------------------------------------------------
    local extra = InspectPlugins.appendEquipmentLines
        and InspectPlugins.appendEquipmentLines(item, statMap, subtype, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        elseif type(extra) == "table" then
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end

    return InspectDescription.finish(b)
end

return M
