local InspectPlugins = require "InspectSystem/Core/Inspect_Plugins"
local M = {}

function M.describe(item, statMap, child, parent)
    local b = InspectDescription.newBuilder()
    local subtype = child

    --------------------------------------------------------
    -- 1) BASE DESCRIPTION POR SUBCATEGORIA
    --------------------------------------------------------
    if subtype == "PistolAmmo" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Ammo_Base_PistolAmmo",
                "Ammunition designed for use in pistol-caliber firearms.")
        )

    elseif subtype == "SMGAmmo" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Ammo_Base_SMGAmmo",
                "Light submachine gun ammunition optimized for high rate of fire.")
        )

    elseif subtype == "RifleAmmo" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Ammo_Base_RifleAmmo",
                "Rifle-grade ammunition intended for medium-to-long range use.")
        )

    elseif subtype == "ShotgunShell" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Ammo_Base_ShotgunShell",
                "Shotgun shells delivering pellet spread at short range.")
        )

    elseif subtype == "SniperAmmo" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Ammo_Base_SniperAmmo",
                "Precision ammunition optimized for long-range accuracy.")
        )

    elseif subtype == "ImprovisedAmmo" then
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Ammo_Base_ImprovisedAmmo",
                "Improvised ammunition with inconsistent performance.")
        )

    else
        InspectDescription.addLine(b,
            InspectUI_tr("IGUI_Inspect_Ammo_Base_Fallback",
                "Ammunition designed for use in compatible firearms.")
        )
    end


    --------------------------------------------------------
    -- 2) STATS TECNICOS DE LA MUNICON
    --------------------------------------------------------
    local function fmt(n, d)
        return InspectUI_fmtNumber(n, d or 1)
    end

    local handled = {}

    local cal = statMap["caliber"]
    if cal then
        handled["caliber"] = true
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Ammo_Stat_Caliber",
            "Caliber: %s.",
            tostring(cal.value or cal.raw)
        )
    end

    local projType = statMap["projectileType"]
    if projType then
        handled["projectileType"] = true
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Ammo_Stat_ProjectileType",
            "Projectile type: %s.",
            tostring(projType.value or projType.raw)
        )
    end

    local grain = statMap["projectileWeight"] or statMap["grain"]
    if grain then
        handled["projectileWeight"] = true
        handled["grain"] = true
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Ammo_Stat_Grain",
            "Projectile weight: %s grains.",
            fmt(grain.value or grain.raw, 1)
        )
    end

    local dmg = statMap["damageMult"]
    if dmg then
        handled["damageMult"] = true
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Ammo_Stat_DamageMult",
            "Damage modifier: %s×.",
            fmt(dmg.value or dmg.raw, 2)
        )
    end

    local pen = statMap["penetration"]
    if pen then
        handled["penetration"] = true
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Ammo_Stat_Penetration",
            "Penetration rating: %s.",
            fmt(pen.value or pen.raw, 2)
        )
    end

    local noise = statMap["noiseMult"]
    if noise then
        handled["noiseMult"] = true
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Ammo_Stat_NoiseMult",
            "Noise modifier: %s×.",
            fmt(noise.value or noise.raw, 2)
        )
    end

    local recoil = statMap["recoilMult"]
    if recoil then
        handled["recoilMult"] = true
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Ammo_Stat_RecoilMult",
            "Recoil modifier: %s×.",
            fmt(recoil.value or recoil.raw, 2)
        )
    end

    local range = statMap["rangeMult"]
    if range then
        handled["rangeMult"] = true
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Ammo_Stat_RangeMult",
            "Range modifier: %s×.",
            fmt(range.value or range.raw, 2)
        )
    end

    local acc = statMap["accuracyMult"]
    if acc then
        handled["accuracyMult"] = true
        InspectDescription.addFormatted(
            b,
            "IGUI_Inspect_Ammo_Stat_AccuracyMult",
            "Accuracy modifier: %s×.",
            fmt(acc.value or acc.raw, 2)
        )
    end

    -- Any remaining stats: include as generic lines
    for key, data in pairs(statMap) do
        if not handled[key] then
            local val = data and (data.value or data.raw) or data
            if val ~= nil then
                InspectDescription.addLine(b, string.format("%s: %s", tostring(key), tostring(val)))
            end
        end
    end


    --------------------------------------------------------
    -- 3) PLUGINS
    --------------------------------------------------------
    local extra = InspectPlugins.appendAmmoLines
        and InspectPlugins.appendAmmoLines(item, statMap, subtype, parent)

    if extra then
        if type(extra) == "string" then
            InspectDescription.addLine(b, extra)
        elseif type(extra) == "table" then
            for _, line in ipairs(extra) do
                InspectDescription.addLine(b, line)
            end
        end
    end


    --------------------------------------------------------
    -- 4) FINALIZAR
    --------------------------------------------------------
    return InspectDescription.finish(b)
end

return M
