local M = {}

M.defs = {

    --------------------------------------------------------
    -- DAMAGE / BALLISTICS
    --------------------------------------------------------
    {
        id = "projectileDamage",
        labelKey = "IGUI_Inspect_Ranged_ProjDamage",
        fallback = "Projectile damage",
        getter = function(item)
            return item.getMaxDamage and item:getMaxDamage()
        end,
    },
    {
        id = "projectileSpeed",
        labelKey = "IGUI_Inspect_Ranged_ProjSpeed",
        fallback = "Projectile speed",
        getter = function(item)
            return item.getProjectileSpeed and item:getProjectileSpeed()
        end,
    },
    {
        id = "soundRadius",
        labelKey = "IGUI_Inspect_Ranged_SoundRadius",
        fallback = "Sound radius",
        getter = function(item)
            return item.getSoundRadius and item:getSoundRadius()
        end,
    },

    --------------------------------------------------------
    -- RANGE
    --------------------------------------------------------
    {
        id = "minRange",
        labelKey = "IGUI_Inspect_Ranged_MinRange",
        fallback = "Minimum range",
        getter = function(item)
            return item.getMinRange and item:getMinRange()
        end,
    },
    {
        id = "maxRange",
        labelKey = "IGUI_Inspect_Ranged_MaxRange",
        fallback = "Maximum range",
        getter = function(item)
            return item.getMaxRange and item:getMaxRange()
        end,
    },

    --------------------------------------------------------
    -- ACCURACY
    --------------------------------------------------------
    {
        id = "aimAccuracy",
        labelKey = "IGUI_Inspect_Ranged_AimAccuracy",
        fallback = "Aim accuracy",
        getter = function(item)
            return item.getAimingMod and item:getAimingMod()
        end,
    },
    {
        id = "hitChance",
        labelKey = "IGUI_Inspect_Ranged_HitChance",
        fallback = "Base hit chance",
        getter = function(item)
            return item.getHitChance and item:getHitChance()
        end,
    },
    {
        id = "critChance",
        labelKey = "IGUI_Inspect_Ranged_CritChance",
        fallback = "Critical chance",
        getter = function(item)
            return item.getCriticalChance and item:getCriticalChance()
        end,
    },

    --------------------------------------------------------
    -- HANDLING / CONTROL
    --------------------------------------------------------
    {
        id = "recoilDelay",
        labelKey = "IGUI_Inspect_Ranged_Recoil",
        fallback = "Recoil delay",
        getter = function(item)
            return item.getRecoilDelay and item:getRecoilDelay()
        end,
    },
    {
        id = "aimTime",
        labelKey = "IGUI_Inspect_Ranged_AimTime",
        fallback = "Aim time",
        getter = function(item)
            return item.getAimingTime and item:getAimingTime()
        end,
    },
    {
        id = "reloadTime",
        labelKey = "IGUI_Inspect_Ranged_Reload",
        fallback = "Reload time",
        getter = function(item)
            return item.getReloadTime and item:getReloadTime()
        end,
    },
    {
        id = "jamChance",
        labelKey = "IGUI_Inspect_Ranged_JamChance",
        fallback = "Jam chance",
        getter = function(item)
            return item.getJamChance and item:getJamChance()
        end,
    },
    {
        id = "bloodiness",
        labelKey = "IGUI_Inspect_Stat_Bloodiness",
        fallback = "Blood",
        getter = function(item)
            if not item or not item.getBloodLevel then return end
            local v = item:getBloodLevel() or 0
            if v <= 0 then return end
            if v <= 1 then v = v * 100 end
            return tostring(math.floor(v + 0.5)) .. "%"
        end,
    },
}

M.order = {
    "projectileDamage",
    "projectileSpeed",
    "soundRadius",
    "minRange",
    "maxRange",
    "aimAccuracy",
    "hitChance",
    "critChance",
    "recoilDelay",
    "aimTime",
    "reloadTime",
    "jamChance",
    "bloodiness",
}

return M
