local M = {}

M.defs = {
    --------------------------------------------------
    -- WEAPONS - COMMON
    --------------------------------------------------
    {
        id       = "damage",
        labelKey = "IGUI_Inspect_Damage",
        fallback = "Damage",
        getter   = function(item)
            if not item or not instanceof(item, "HandWeapon") then return end
            local minD = item:getMinDamage() or 0
            local maxD = item:getMaxDamage() or 0
            if minD <= 0 and maxD <= 0 then return end
            if math.abs(maxD - minD) < 0.01 then
                return InspectUI_fmtNumber(maxD, 2)
            end
            return InspectUI_fmtNumber(minD, 2) .. " - " .. InspectUI_fmtNumber(maxD, 2)
        end,
    },
    {
        id       = "range",
        labelKey = "IGUI_Inspect_Range",
        fallback = "Range",
        getter   = function(item)
            if not item or not instanceof(item, "HandWeapon") then return end
            local minR = item:getMinRange() or 0
            local maxR = item:getMaxRange() or 0
            if minR <= 0 and maxR <= 0 then return end
            if math.abs(maxR - minR) < 0.01 then
                return InspectUI_fmtNumber(maxR, 2)
            end
            return InspectUI_fmtNumber(minR, 2) .. " - " .. InspectUI_fmtNumber(maxR, 2)
        end,
    },
    {
        id       = "crit",
        labelKey = "IGUI_Inspect_CritChance",
        fallback = "Crit chance",
        getter   = function(item)
            if not item or not instanceof(item, "HandWeapon") then return end
            if not item.getCriticalChance then return end

            local c = item:getCriticalChance() or 0
            if c <= 0 then return end

            -- En scripts vanilla suele estar 0-100.
            -- Si viene como 0.0-1.0 lo convertimos a %, si no lo dejamos.
            if c <= 1 then
                c = c * 100
            end

            return tostring(math.floor(c + 0.5)) .. "%"
        end,
    },
    {
        id       = "accuracy",
        labelKey = "IGUI_Inspect_Stat_Accuracy",
        fallback = "Accuracy",
        getter   = function(item)
            if not item or not instanceof(item, "HandWeapon") then return end
            if not item.getToHitModifier then return end

            local v = item:getToHitModifier()
            if v == nil then return end

            -- La mayoria de armas usan valores tipo 0.8, 1.2, 1.5...
            -- Los convertimos a % si estan en un rango razonable
            if v >= -3 and v <= 3 then
                v = v * 100
                return InspectUI_fmtNumber(v, 0) .. "%"
            end

            -- Fallback numerico si algun mod usa otro rango raro
            return InspectUI_fmtNumber(v, 2)
        end,
    },
    {
        id       = "noiseRadius",
        labelKey = "IGUI_Inspect_Stat_NoiseRadius",
        fallback = "Noise radius",
        getter   = function(item)
            if not item or not instanceof(item, "HandWeapon") then return end
            if not item.getSoundRadius then return end

            local r = item:getSoundRadius()
            if not r or r <= 0 then return end

            -- Radio en tiles
            return tostring(math.floor(r + 0.5))
        end,
    },
    {
        id       = "knockback",
        labelKey = "IGUI_Inspect_Stat_Knockback",
        fallback = "Knockback",
        getter   = function(item)
            if not item or not instanceof(item, "HandWeapon") then return end
            if not item.getPushBackMod then return end

            local ok, v = pcall(item.getPushBackMod, item)
            if not ok or not v or v == 0 then return end

            -- Normalmente es un valor pequeno tipo 0.3 / 0.5 -> lo pasamos a %
            if v <= 1 then
                v = v * 100
            end

            return InspectUI_fmtNumber(v, 0) .. "%"
        end,
    },
    {
        id       = "hands",
        labelKey = "IGUI_Inspect_Hands",
        fallback = "Hands",
        getter   = function(item)
            if not item or not instanceof(item, "HandWeapon") then return end

            if item.isTwoHandWeapon and item:isTwoHandWeapon() then
                return InspectUI_tr("IGUI_Inspect_TwoHanded", "Two-handed")
            end

            -- Si no es 2H asumimos que es 1H (para la mayoria de armas)
            return InspectUI_tr("IGUI_Inspect_OneHanded", "One-handed")
        end,
    },
    {
        id       = "maxHitCount",
        labelKey = "IGUI_Inspect_MaxHitCount",
        fallback = "Targets per swing",
        getter   = function(item)
            if not item or not instanceof(item, "HandWeapon") then return end
            if not item.getMaxHitCount then return end

            local v = item:getMaxHitCount() or 0
            if v <= 1 then return end -- 1 objetivo = no tiene sentido mostrarlo
            return tostring(v)
        end,
    },
}

M.order = {
    "damage",
    "range",
    "crit",
    "accuracy",
    "noiseRadius",
    "knockback",
    "hands",
    "maxHitCount",
}

return M
