local M = {}

M.defs = {
    --------------------------------------------------
    -- CLOTHING
    --------------------------------------------------
    {
        id       = "insulation",
        labelKey = "IGUI_Inspect_Insulation",
        fallback = "Insulation",
        getter   = function(item)
            if not item or not instanceof(item, "Clothing") then return end
            if not item.getInsulation then return end
            local v = item:getInsulation() or 0
            if v <= 0 then return end
            return InspectUI_fmtNumber(v, 2)
        end,
    },
    {
        id       = "windRes",
        labelKey = "IGUI_Inspect_WindRes",
        fallback = "Wind resistance",
        getter   = function(item)
            if not item or not item.getWindresist then return end
            local v = item:getWindresist() or 0
            if v <= 0 then return end
            return tostring(math.floor(v * 100)) .. "%"
        end,
    },
    {
        id       = "waterRes",
        labelKey = "IGUI_Inspect_WaterRes",
        fallback = "Water resistance",
        getter   = function(item)
            if not item or not instanceof(item, "Clothing") then return end
            if not item.getWaterresist then return end
            local v = item:getWaterresist() or 0
            if v <= 0 then return end
            return tostring(math.floor(v * 100)) .. "%"
        end,
    },
    {
        id       = "dirtiness",
        labelKey = "IGUI_Inspect_Stat_Dirtiness",
        fallback = "Dirtiness",
        getter   = function(item)
            if not item or not item.getDirtyness then return end
            -- Solo ropa/accesorios
            if (instanceof and instanceof(item, "Clothing")) == false then
                local loc = item.getBodyLocation and item:getBodyLocation()
                if not loc or loc == "" then return end
            end

            local v = item:getDirtyness() or 0
            if v <= 0 then
                return InspectUI_tr("IGUI_Inspect_No", "No")
            end
            if v <= 1 then v = v * 100 end
            return tostring(math.floor(v + 0.5)) .. "%"
        end,
    },
    {
        id       = "bloodiness",
        labelKey = "IGUI_Inspect_Stat_Bloodiness",
        fallback = "Blood",
        getter   = function(item)
            if not item or not item.getBloodLevel then return end
            -- Solo ropa/accesorios
            if (instanceof and instanceof(item, "Clothing")) == false then
                local loc = item.getBodyLocation and item:getBodyLocation()
                if not loc or loc == "" then return end
            end

            local v = item:getBloodLevel() or 0
            if v <= 0 then
                return InspectUI_tr("IGUI_Inspect_No", "No")
            end
            if v <= 1 then v = v * 100 end
            return tostring(math.floor(v + 0.5)) .. "%"
        end,
    },
    {
        id       = "biteDefense",
        labelKey = "IGUI_Inspect_BiteDefense",
        fallback = "Bite defense",
        getter   = function(item)
            if not item or not instanceof(item, "Clothing") then return end
            if not item.getBiteDefense then return end
            local v = item:getBiteDefense() or 0
            if v <= 0 then return end
            return tostring(v)
        end,
    },
    {
        id       = "scratchDefense",
        labelKey = "IGUI_Inspect_ScratchDefense",
        fallback = "Scratch defense",
        getter   = function(item)
            if not item or not instanceof(item, "Clothing") then return end
            if not item.getScratchDefense then return end
            local v = item:getScratchDefense() or 0
            if v <= 0 then return end
            return tostring(v)
        end,
    },
    {
        id       = "runSpeed",
        labelKey = "IGUI_Inspect_Stat_RunSpeed",
        fallback = "Run speed",
        getter   = function(item)
            if not item or not instanceof(item, "Clothing") then return end
            if not item.getRunSpeedModifier then return end

            local v = item:getRunSpeedModifier()
            if not v or v == 1 then
                -- 1.0 = sin modificador, no mostramos nada
                return
            end

            -- Interpretacion: valores menores que 1 ralentizan al personaje.
            -- Calculamos el porcentaje de penalizacion.
            local delta = (1 - v) * 100
            if math.abs(delta) < 1 then
                return
            end

            -- Ej: v = 0.9 -> delta = 10 -> "10%"
            return InspectUI_fmtNumber(delta, 0) .. "%"
        end,
    },
}

M.order = {
    "insulation",
    "windRes",
    "waterRes",
    "dirtiness",
    "bloodiness",
    "biteDefense",
    "scratchDefense",
    "runSpeed",
}

return M
