local M = {}

M.defs = {
    --------------------------------------------------
    -- BOOKS / LITERATURE
    --------------------------------------------------
    {
        id       = "bookBoredom",
        labelKey = "IGUI_Inspect_Book_Boredom",
        fallback = "Boredom reduction",
        getter   = function(item)
            if not item or not instanceof(item, "Literature") then return end
            if not item.getBoredomChange then return end
            local v = item:getBoredomChange()
            if not v or v >= 0 then return end -- solo reducciones
            return InspectUI_fmtNumber(math.abs(v), 1)
        end,
    },
    {
        id       = "bookStress",
        labelKey = "IGUI_Inspect_Book_Stress",
        fallback = "Stress reduction",
        getter   = function(item)
            if not item or not instanceof(item, "Literature") then return end
            if not item.getStressChange then return end
            local v = item:getStressChange()
            if not v or v >= 0 then return end -- solo reducciones
            return InspectUI_fmtNumber(math.abs(v), 1)
        end,
    },
    {
        id       = "pagesTotal",
        labelKey = "IGUI_Inspect_PagesTotal",
        fallback = "Pages",
        getter   = function(item)
            if not item or not instanceof(item, "Literature") then return end
            if not item.getNumberOfPages then return end
            local v = item:getNumberOfPages() or 0
            if v <= 0 then return end
            return tostring(v)
        end,
    },
    {
        id       = "pagesLeft",
        labelKey = "IGUI_Inspect_PagesLeft",
        fallback = "Pages left",
        getter   = function(item)
            if not item or not instanceof(item, "Literature") then return end
            if not (item.getNumberOfPages and item.getAlreadyReadPages) then return end
            local total = item:getNumberOfPages() or 0
            local read  = item:getAlreadyReadPages() or 0
            if total <= 0 then return end
            local left = math.max(0, total - read)
            if left == 0 then return end
            return tostring(left)
        end,
    },
    {
        id       = "skillBook",
        labelKey = "IGUI_Inspect_Stat_SkillBook",
        fallback = "Skill / Max level",
        getter   = function(item)
            if not item or not instanceof(item, "Literature") then return end
            if not (item.getSkillTrained and item.getMaxLevelTrained) then return end
            local skill = item:getSkillTrained()
            local max   = item:getMaxLevelTrained()
            if not skill or not max or max <= 0 then return end
            local min = math.max(1, max - 1)
            return tostring(skill) .. " (" .. tostring(min) .. "-" .. tostring(max) .. ")"
        end,
    },
}

M.order = {
    "bookBoredom",
    "bookStress",
    "pagesTotal",
    "pagesLeft",
    "skillBook",
}

return M
