local M = {}

M.defs = {
    --------------------------------------------------
    -- BASE / GENERIC
    --------------------------------------------------
    {
        id       = "weight",
        labelKey = "IGUI_Inspect_Weight",
        fallback = "Weight",
        getter   = function(item)
            if item and item.getWeight then
                return InspectUI_fmtNumber(item:getWeight(), 2)
            end
        end,
    },
    {
        id       = "category",
        labelKey = "IGUI_Inspect_Category",
        fallback = "Category",
        getter   = function(item)
            if item and item.getCategory then
                return tostring(item:getCategory())
            end
        end,
    },
    {
        id       = "displayCategory",
        labelKey = "IGUI_Inspect_DisplayCategory",
        fallback = "Type",
        getter   = function(item)
            if item and item.getDisplayCategory then
                local ok, cat = pcall(function() return item:getDisplayCategory() end)
                if ok and cat and cat ~= "" then
                    return tostring(cat)
                end
            end
        end,
    },
    {
        id       = "weaponSubtype",
        labelKey = "IGUI_Inspect_WeaponSubtype",
        fallback = "Weapon subtype",
        getter   = function(item)
            if not item then return end

            local parent, child = InspectUI_resolveCategory(item)
            if parent ~= "Weapons" or not child or child == "" then
                return
            end

            -- Skip generic branch buckets
            if child == "Melee" or child == "Firearm" then
                return
            end

            local labels = {
                ["Melee/Axe"]        = "Axe",
                ["Melee/LongBlunt"]  = "Long Blunt",
                ["Melee/ShortBlunt"] = "Short Blunt",
                ["Melee/LongBlade"]  = "Long Blade",
                ["Melee/ShortBlade"] = "Short Blade",
                ["Melee/Spear"]      = "Spear",
                ["Melee/Improvised"] = "Improvised",
                ["Firearm/Pistol"]   = "Pistol",
                ["Firearm/Revolver"] = "Revolver",
                ["Firearm/Rifle"]    = "Rifle",
                ["Firearm/Shotgun"]  = "Shotgun",
                ["Firearm/SMG"]      = "SMG",
                ["Firearm/Other"]    = "Other",
            }

            return labels[child] or child
        end,
    },
    {
        id       = "condition",
        labelKey = "IGUI_Inspect_Condition",
        fallback = "Condition",
        getter   = function(item)
            if not item or not item.getCondition or not item.getConditionMax then return end

            -- Evitar mostrar condicion en items realmente drainables
            local ud = item.getUseDelta and item:getUseDelta() or 0
            if ud and ud > 0 and ud < 1 then
                return
            end
            local dui = item.getDrainableUsesInt and item:getDrainableUsesInt() or 0
            if dui and dui > 0 then
                return
            end
            if instanceof and instanceof(item, "DrainableComboItem") then
                return
            end

            local cur = item:getCondition() or 0
            local max = item:getConditionMax() or 0
            if max <= 0 then return end
            return tostring(cur) .. " / " .. tostring(max)
        end,
    },
    {
        id       = "usesLeft",
        labelKey = "IGUI_Inspect_Stat_Uses",
        fallback = "Uses",
        getter   = function(item)
            if not item then return end

            -- No mostrar usos para ropa/accesorios
            local cat = item.getCategory and item:getCategory() or ""
            if (instanceof and instanceof(item, "Clothing"))
                or (item.getBodyLocation and item:getBodyLocation())
                or string.lower(cat) == "clothing" then
                return
            end

            local remaining
            local total
            local ok, val

            -- APIs directas de remaining (mods pueden rellenarlas)
            if item.getRemainingUses then
                ok, val = pcall(function() return item:getRemainingUses() end)
                if ok and val and val > 0 then
                    remaining = val
                end
            end
            if (not remaining) and item.getCurrentUses then
                ok, val = pcall(function() return item:getCurrentUses() end)
                if ok and val and val > 0 then
                    remaining = val
                end
            end

            local useDelta = item.getUseDelta and item:getUseDelta() or nil
            local usedDelta = item.getUsedDelta and item:getUsedDelta() or nil

            -- Derivar total desde useDelta (más fiable que DrainableUsesInt para pills/bottles)
            if useDelta and useDelta > 0 and useDelta < 1 then
                total = math.floor(1 / useDelta + 0.5)
            end

            -- Fallback: API que algunos mods rellenan como total
            if (not total or total <= 0) and item.getDrainableUsesInt then
                ok, val = pcall(function() return item:getDrainableUsesInt() end)
                if ok and val and val > 0 then
                    total = val
                end
            end

            -- Calcular remaining con usedDelta si tenemos ambos
            if (not remaining) and total and total > 0 and usedDelta then
                if usedDelta < 0 then usedDelta = 0 end
                if usedDelta > 1 then usedDelta = 1 end
                remaining = math.floor(total * (1 - usedDelta) + 0.0001)
            end

            -- Si no hay usedDelta, intentar con delta (suele ser fracción restante)
            if (not remaining or remaining < 0) and total and total > 0 and item.getDelta then
                local delta = item:getDelta()
                if delta and delta >= 0 and delta <= 1 then
                    remaining = math.floor(total * delta + 0.0001)
                end
            end

            -- Si seguimos sin remaining pero sí total, mostrar total como mínimo
            if (not remaining or remaining < 0) and total and total > 0 then
                remaining = total
            end

            if (not remaining or remaining < 0) or (not total or total <= 0) then return end

            if remaining > total then
                remaining = total
            end

            return tostring(remaining) .. " / " .. tostring(total)
        end,
    },
    {
        id       = "lightDistance",
        labelKey = "IGUI_Inspect_Stat_LightDistance",
        fallback = "Light distance",
        getter   = function(item)
            if not item or not item.getLightDistance then return end

            local dist = item:getLightDistance()
            if not dist or dist <= 0 then return end

            -- Distancia en tiles (entera)
            return tostring(math.floor(dist + 0.5))
        end,
    },
    {
        id       = "lightStrength",
        labelKey = "IGUI_Inspect_Stat_LightStrength",
        fallback = "Light strength",
        getter   = function(item)
            if not item or not item.getLightStrength then return end

            local s = item:getLightStrength()
            if not s or s <= 0 then return end

            -- Valor tal cual (normalmente 0.x - 2.x)
            return InspectUI_fmtNumber(s, 2)
        end,
    },
}

M.order = {
    "weight",
    "category",
    "displayCategory",
    "weaponSubtype",
    "condition",
    "usesLeft",
    "lightDistance",
    "lightStrength",
}

return M
