----------------------------------------------------------
-- Inspect_CategoryTree.lua
-- v3.7 Modular Category Loader
----------------------------------------------------------

local CategoryTree = {}

local modules = {
    "InspectSystem/Core/Categories/Category_Weapons",
    "InspectSystem/Core/Categories/Category_Weapons_Melee",
    "InspectSystem/Core/Categories/Category_Weapons_Firearm",
    "InspectSystem/Core/Categories/Category_Ammo",
    "InspectSystem/Core/Categories/Category_Tools",
    "InspectSystem/Core/Categories/Category_Food",
    "InspectSystem/Core/Categories/Category_Clothing",
    "InspectSystem/Core/Categories/Category_Materials",
    "InspectSystem/Core/Categories/Category_Electronics",
    "InspectSystem/Core/Categories/Category_Medical",
    "InspectSystem/Core/Categories/Category_Moveable",
    "InspectSystem/Core/Categories/Category_Fluid",
    "InspectSystem/Core/Categories/Category_Literature",
    "InspectSystem/Core/Categories/Category_Junk",
    "InspectSystem/Core/Categories/Category_Corpse",
}

for _, path in ipairs(modules) do
    local ok, module = pcall(require, path)
    if ok and module and module.rules then
        for _, rule in ipairs(module.rules) do
            table.insert(CategoryTree, rule)
        end
    else
        print("ItemInspectionUI: Failed to load category module:", path)
    end
end

table.sort(CategoryTree, function(a, b)
    local pa = a.priority or 0
    local pb = b.priority or 0
    if pa == pb then
        return (a.id or "") < (b.id or "")
    end
    return pa > pb
end)

return CategoryTree
