----------------------------------------------------------
-- Category_Weapons_Melee.lua
-- Melee subcategories (v3.9 modular)
----------------------------------------------------------

local C = {}
C.parent = "Weapons"

local IMPROVISED_TOKENS = {
    "pen",
    "pencil",
    "flint",
    "nodule",
    "compass",
    "geometry",
}

local function lower(val)
    if not val then return "" end
    return string.lower(tostring(val))
end

local function getWeaponSkillType(item)
    if not (instanceof and instanceof(item, "HandWeapon")) then
        return nil
    end
    local wt = item.getWeaponType and item:getWeaponType()
    if not wt or wt == "" then return nil end
    return lower(wt)
end

local function matchImprovised(text)
    text = lower(text or "")
    for _, t in ipairs(IMPROVISED_TOKENS) do
        if text:find(t, 1, true) then
            return true
        end
    end
    return false
end

local function isMeleeWeapon(item)
    if not (instanceof and instanceof(item, "HandWeapon")) then
        return false
    end
    if item.getAmmoType then
        local ammo = item:getAmmoType()
        if ammo and ammo ~= "" then return false end
    end
    return true
end

local function hasWeaponType(item, skillType)
    return isMeleeWeapon(item) and getWeaponSkillType(item) == skillType
end

C.rules = {
    {
        id = "Weapons.Melee.Axe",
        priority = 92,
        match = function(item, statMap)
            return hasWeaponType(item, "axe")
        end,
        category = "Weapons/Melee/Axe",
    },

    {
        id = "Weapons.Melee.LongBlunt",
        priority = 92,
        match = function(item, statMap)
            return hasWeaponType(item, "longblunt")
        end,
        category = "Weapons/Melee/LongBlunt",
    },

    {
        id = "Weapons.Melee.ShortBlunt",
        priority = 92,
        match = function(item, statMap)
            return hasWeaponType(item, "smallblunt")
        end,
        category = "Weapons/Melee/ShortBlunt",
    },

    {
        id = "Weapons.Melee.LongBlade",
        priority = 92,
        match = function(item, statMap)
            return hasWeaponType(item, "longblade")
        end,
        category = "Weapons/Melee/LongBlade",
    },

    {
        id = "Weapons.Melee.ShortBlade",
        priority = 92,
        match = function(item, statMap)
            return hasWeaponType(item, "smallblade")
        end,
        category = "Weapons/Melee/ShortBlade",
    },

    {
        id = "Weapons.Melee.Spear",
        priority = 92,
        match = function(item, statMap)
            return hasWeaponType(item, "spear")
        end,
        category = "Weapons/Melee/Spear",
    },

    {
        id = "Weapons.Melee.Improvised",
        priority = 92,
        match = function(item, statMap)
            if not isMeleeWeapon(item) then return false end
            local wt = getWeaponSkillType(item)
            if wt and wt ~= "" then return false end
            return matchImprovised(item.getDisplayName and item:getDisplayName())
                or matchImprovised(item.getDisplayCategory and item:getDisplayCategory())
                or matchImprovised(item.getCategory and item:getCategory())
        end,
        category = "Weapons/Melee/Improvised",
    },
}

return C
