----------------------------------------------------------
-- Category_Medical.lua
-- Token-based rules (v3.8)
----------------------------------------------------------

local C = {}
C.parent = "Medical"

-- token tables
local TOKENS = {
    Medical = { "medical", "first" },
}

-- Universal token matcher for all categories
local function matchTokens(text, tokens)
    for _, token in ipairs(tokens) do
        if text:find(token, 1, true) then
            return true
        end
    end
    return false
end

local function lower(val)
    if not val then return "" end
    return string.lower(tostring(val))
end

local function getText(item)
    local dc = lower(item.getDisplayCategory and item:getDisplayCategory())
    local name = lower(item.getDisplayName and item:getDisplayName())
    return (dc or "") .. " " .. (name or "")
end

C.rules = {
    {
        id = "Medical.BaseCheck",
        priority = 50,
        match = function(item, statMap)
            return matchTokens(getText(item), TOKENS.Medical)
        end,
        category = "Medical",
    },
}

return C
