-- Safe-guard for vanilla AnimalContextMenu when the target animal is nil or lacks stats.
-- Fully protected version to avoid conflicts with other mods.

require "ISUI/ISAnimalContextMenu"

-- Validate AnimalContextMenu table
if not AnimalContextMenu then
    return -- Another mod removed or replaced the entire table
end

local original = AnimalContextMenu.doFeedFromHandMenu

-- Only wrap if the function actually exists
if type(original) == "function" then
    AnimalContextMenu.doFeedFromHandMenu = function(playerObj, animal, context)
        -- If animal is nil, corrupted or has no proper stats, skip safely
        if not animal or type(animal) ~= "table" or not animal.getStats then
            return
        end

        -- pcall prevents crashes if another mod's override is broken
        local ok, stats = pcall(function()
            return animal:getStats()
        end)

        if not ok or not stats then
            return
        end

        -- Call original safely
        return original(playerObj, animal, context)
    end
else
    -- Another mod removed or replaced this function with non-function.
    -- Do not override to avoid breaking compatibility.
end
