--========================================================
-- ItemInspectionUI - Context menu hook (VanillaPlus)
--========================================================

require "InspectUI/UI/Inspect_UI_VanillaPlus"

ItemInspectionUI = ItemInspectionUI or {}

-- Resuelve el InventoryItem real desde la tabla "items"
local function resolveItemFromContext(items)
    if not items or #items == 0 then
        return nil
    end

    local entry = items[1]

    -- Caso 1: directamente un InventoryItem
    if instanceof(entry, "InventoryItem") then
        return entry
    end

    -- Caso 2: tabla con campo .items (estándar del contexto de PZ)
    if entry.items and #entry.items > 0 then
        for _, v in ipairs(entry.items) do
            if instanceof(v, "InventoryItem") then
                return v
            end
        end
    end

    return nil
end

local function OnFillInventoryObjectContextMenu(playerIndex, context, items)
    local player = getSpecificPlayer(playerIndex)
    if not player then return end

    local item = resolveItemFromContext(items)
    if not item then return end

    if not InspectUI_VanillaPlus or not InspectUI_VanillaPlus.open then
        return
    end

    -- Texto traducible (fallback a texto plano si falta la key)
    local optionText = getText("IGUI_ContextMenu_InspectItem") or "Inspect Item"

    -- Añadimos la opción
    local opt = context:addOption(optionText, item, function()
        local p = getSpecificPlayer(playerIndex)
        InspectUI_VanillaPlus.open(item, p)
    end)

    -- Forzar que nuestra opción quede la PRIMERA del menú
    if opt and context.options then
        local opts = context.options
        for i, o in ipairs(opts) do
            if o == opt then
                table.remove(opts, i)
                table.insert(opts, 1, opt)
                break
            end
        end
    end
end

Events.OnFillInventoryObjectContextMenu.Add(OnFillInventoryObjectContextMenu)
