--==========================================================
-- Inspect Items Framework - Rotation Profile System
-- Provides default rotation presets for item categories
--==========================================================
local RotationProfile = {}

--------------------------------------------------------------
-- DEFAULT ROTATIONS BY CATEGORY
--------------------------------------------------------------
RotationProfile.defaults = {

    ----------------------------------------------------------
    -- WEAPONS
    ----------------------------------------------------------
    Weapon = { angleX = 15, angleY = 90,  angleZ = 0 },   -- Firearms & melee (generic)
    Firearm = { angleX = 15, angleY = 90, angleZ = 0 },   -- Guns specifically
    Melee = { angleX = 0, angleY = 90, angleZ = 0 },       -- Horizontal melee weapons

    ----------------------------------------------------------
    -- AMMO
    ----------------------------------------------------------
    Ammo = { angleX = 25, angleY = 45, angleZ = 0 },

    ----------------------------------------------------------
    -- CLOTHING
    ----------------------------------------------------------
    Clothing = { angleX = 0, angleY = 180, angleZ = 0 },

    ----------------------------------------------------------
    -- FOOD & DRINKS
    ----------------------------------------------------------
    Food = { angleX = 30, angleY = 45, angleZ = 0 },
    Drainable = { angleX = 20, angleY = 45, angleZ = 0 }, -- bottles, cans, drinks

    ----------------------------------------------------------
    -- MEDICAL
    ----------------------------------------------------------
    Medical = { angleX = 30, angleY = 45, angleZ = 0 },

    ----------------------------------------------------------
    -- TOOLS
    ----------------------------------------------------------
    Tool = { angleX = 20, angleY = 60, angleZ = 0 },

    ----------------------------------------------------------
    -- BOOKS / MAGAZINES
    ----------------------------------------------------------
    Literature = { angleX = 0, angleY = 180, angleZ = 0 },

    ----------------------------------------------------------
    -- ELECTRONICS
    ----------------------------------------------------------
    Electronics = { angleX = 30, angleY = 60, angleZ = 0 },

    ----------------------------------------------------------
    -- GENERIC FALLBACK
    ----------------------------------------------------------
    Default = { angleX = 15, angleY = 135, angleZ = 0 },
}

--------------------------------------------------------------
-- API: Get rotation for an item
--------------------------------------------------------------
function RotationProfile.getRotation(item)
    if not item then return RotationProfile.defaults.Default end

    local category = item.getCategory and item:getCategory() or nil

    -- Special case: Firearms (more reliable detection)
    if item.getWeaponSprite and item:getWeaponSprite() then
        return RotationProfile.defaults.Firearm
    end

    -- Durable melee weapons
    if category == "Weapon" and item.isAimedFirearm == nil then
        return RotationProfile.defaults.Melee
    end

    -- By category
    if RotationProfile.defaults[category] then
        return RotationProfile.defaults[category]
    end

    -- Fallback
    return RotationProfile.defaults.Default
end

--------------------------------------------------------------
-- API: Allow other mods/scripts to override a profile
--------------------------------------------------------------
function RotationProfile.setProfile(category, rot)
    RotationProfile.defaults[category] = rot
end

return RotationProfile
