# Changelog - Woody's Rain & Wet Snow Cleaning

**Testing Feedback Needed:** This mod is hard to test comprehensively (rain patterns, fear of blood progressive mode,
multiplayer, edge cases). Feedback and suggestions are greatly appreciated! Please report any issues or improvements in
the comments.

---

## Version 1.1.1 (December 9th, 2025)

### Fixed

- **Critical syntax error:** Removed accidental debug token (`ASSSUF3-247`) from WoodysRainSnow_WringHook.lua that
  prevented mod from loading.

---

## Version 1.1.0 (December 9th, 2025)

### Added

- **New wringing mechanic:** Wringing wet clothes now partially removes dirt (up to 30% for damp, up to 50% for soaked
  clothes) and 5% of blood, with cleaning scaled nonlinearly by wetness.
- **Rain cleaning penalty:** The dirtier the clothing, the slower the passive cleaning—heavy grime requires wringing or
  manual washing first.
- **All new logic is fully configurable via Mod Options** (sliders/tickboxes for penalty strength, wringing efficiency,
  blood removal, and more).
- **Debug logs:** Added one-line debug logs for major cleaning actions (rain, wring, manual wash) using [WOODYDEBUG]
  format for easy troubleshooting.
- **Better Wringing mod compatibility:** Seamless hook into vanilla and Better Wringing, no conflicts.

### Changed

- Rain/snow cleaning rates are now progressive: Light dirt washes off quickly, medium/heavy dirt slows cleaning
  dramatically.

### Fixed

- Clean and clear code for dirty/wet calculation (progressive, not stepped).
- Improved null safety throughout (no risk of a crash in edge cases).

### Technical

- Events and cleaning code refactored for clarity and maintainability.
- Sectioned all debug logs with [WOODYDEBUG] and adopted unified one-liner format.

### Known Limitations

1. Penalty and cleaning multipliers are best-effort balanced - feedback welcome to tune defaults.
2. Rain and wringing cleaning are not instant; some heavy grime may require multiple actions.
3. Debug logs remain enabled for playtesting - thanks.

## Version 1.0.1 (December 4th, 2025)

- Null safety (guards everywhere, crashless)
- Excessive debug logs in every method

## Version 1.0.0 (November 30th, 2025)

### Initial Release

Realistic rain cleaning system **written from scratch** with modern B42 systems and QoL-focused approach!

### Added

#### Core Features

- **Auto-Rain Cleaning** - stand outside in rain/wet snow - blood and dirt gradually clean off
- **Wet Snow Support** - temperature-based detection (40% as effective as rain, between -1°C to 2°C)
- **Separate Blood & Dirt Tracking** - each stat cleans independently
- **Linear Modifiers** - predictable, easy-to-understand behavior (50% wet = 50% effective)
- **Water Resistance Penalty** - waterproof clothing is harder to clean (less water absorption = less effective washing)

#### Fear of Blood Trait Support

**The Problem:** Vanilla washing takes time. When covered in blood, Fear of Blood characters get sad (unhappiness),
which **increases action duration**. More blood = longer washing = bizarre gameplay loop.

**The Solution:** Optional boost for vanilla manual washing (right-click water > "Wash Yourself"). Fear of Blood
characters
are **extra motivated** to clean blood ASAP!

**Configurable Modes:**

- **1.25x** - slight speed boost
- **1.5x** - moderate speed boost
- **2x** - significant speed boost (default recommended)
- **3x** - extreme speed boost

#### Realistic Timing (Wife-Approved!)

Consulted with my wife about realistic rain washing times - she confirmed these feel right!

**90% clean in strong rain (~80% intensity, 100% wetness):**

- **Blood:** ~2h 20min
- **Dirt:** ~1h 30min
- **Wet snow:** 2.5x slower (40% effectiveness)

**Storm (100% intensity):**

- **Blood:** ~1h 30min
- **Dirt:** ~1h

#### Supported Items

- **Body parts** - all blood/dirt from character's body
- **Clothing** - all worn clothes (shirts, pants, shoes, gloves, etc.)
- **Bags** - equipped backpacks, duffle bags, etc.
- **Weapons** - equipped and attached weapons (axe on back, knife in belt, etc.)

### Technical

- **PZAPI ModOptions** - native B42 config system (no external dependencies!)
- **Separate blood/dirt tracking** - each stat cleans independently
- **Linear behavior** - predictable, easy to understand (50% wet = 50% effective)

### Compatibility

- **Complementary to Rain Cleans Blood** - that mod cleans ground/walls, this cleans character/clothing. Perfect combo!

### Configuration (PZAPI ModOptions)

**Options > Mods > Rain & Wet Snow Cleaning:**

- **Wet Snow Cleaning** - ON/OFF (default: ON)
- **Fear of Blood Boost** - Off / 1.5x / 2x / 3x / Auto (default: Off)

### Known Limitations

1. **Fear of Blood boost** - only works if character has Fear of Blood trait (checked via
   `character:HasTrait("Hemophobic")`)
2. **No ground/walls cleaning** - use "Rain Cleans Blood" mod for that!

### Files Created

- `WoodysRainSnow_Core.lua` - main auto-rain cleaning logic (350 lines, fully documented)
- `WoodysRainSnow_Config.lua` - PZAPI ModOptions integration
- `WoodysRainSnow_ManualWash.lua` - manual washing TimedAction
- `WoodysRainSnow_Init.lua` - module loader

---------------------------------------------------------------------------------------
