--***********************************************************
--**                    WOODY'S MODS                       **
--**     Rain & Wet Snow Cleaning - Client               **
--***********************************************************

local WoodysRainSnow_Config = require("WoodysRainSnow_Config")
local WoodysRainSnow_WringHook = require("WoodysRainSnow_WringHook")

local WoodysRainSnow_Client = {}

-- Initialize mod options when UI is ready with protection
function WoodysRainSnow_Client.initModOptions()
    local ok, err = pcall(function()
        WoodysRainSnow_Config.initialize()
    end)
    
    if not ok then
        print("[WOODYDEBUG]_RainSnow:_ModOptions_initialization_failed_" .. tostring(err))
        print("[WOODYDEBUG]_RainSnow:_Fallback_using_default_values")
    end
end

-- Hook into game events
Events.OnCreateUI.Add(WoodysRainSnow_Client.initModOptions)

print("[WOODYDEBUG]_RainSnow:_All_modules_loaded")

return WoodysRainSnow_Client
