require "TimedActions/ISBaseTimedAction"

PumpsHavePropane_Action = ISBaseTimedAction:derive("PumpsHavePropane_Action")

function PumpsHavePropane_Action:isValid()
    if not self.pump then return false end
    if not self.item then return false end
    if not self.item:getContainer() then return false end
    return true
end

function PumpsHavePropane_Action:waitToStart()
    self.character:faceLocation(self.pump:getSquare():getX(), self.pump:getSquare():getY())
    return self.character:shouldBeTurning()
end

function PumpsHavePropane_Action:update()
    self.item:setJobDelta(self:getJobDelta())
    self.character:faceLocation(self.pump:getSquare():getX(), self.pump:getSquare():getY())
    
    -- Візуальна смужка прогресу
    local currentDelta = self:getJobDelta()
    if self.item.setUseDelta then self.item:setUseDelta(currentDelta) end
    if self.item.setUsedDelta then self.item:setUsedDelta(currentDelta) end

    self.character:setMetabolicTarget(Metabolics.LightWork)
end

function PumpsHavePropane_Action:start()
    if self.isTorch then
        self:setOverrideHandModels(nil, "BlowTorch")
        self:setActionAnim("Loot") 
    else
        self:setOverrideHandModels(nil, "PropaneTank")
        self:setActionAnim("TakeGasFromPump")
    end
    
    self.item:setJobType(getText("ContextMenu_TakePropaneFromPump"))
    self.item:setJobDelta(0.0)
    self.targetDelta = 1.0 
end

function PumpsHavePropane_Action:stop()
    self.item:setJobDelta(0.0)
    ISBaseTimedAction.stop(self)
end

function PumpsHavePropane_Action:perform()
    self.item:setJobDelta(0.0)
    
    local container = self.item:getContainer()
    if container then
        local typeName = self.item:getFullType()
        local condition = self.item:getCondition()
        
        -- 1. Видаляємо старий (порожній/глючний) предмет
        container:Remove(self.item)
        
        -- 2. Створюємо новий (свіжий, з правильними параметрами ваги від розробників)
        local newItem = container:AddItem(typeName)
        
        if newItem then
            -- Відновлюємо стан (зношеність)
            newItem:setCondition(condition)
            
            -- КРОК 1: Візуально повний
            if newItem.setUsedDelta then newItem:setUsedDelta(1.0) end

            -- КРОК 2: Синхронізуємо заряди з нативним максимумом
            local maxUses = 1 
            if newItem.getMaxUses then maxUses = newItem:getMaxUses() end
            
            -- Страховка від глюка рушія
            if maxUses < 1 then maxUses = 1 end

            -- Заливаємо до максимуму
            if newItem.setCurrentUses then newItem:setCurrentUses(maxUses) end

            -- Оновлюємо модель в руках
            if container:getParent() and container:getParent() == self.character then
                self.character:resetModel()
            end
        end
    end

    ISBaseTimedAction.perform(self)
end

function PumpsHavePropane_Action:new(pump, item, character, duration, isTorch)
    local o = {}
    setmetatable(o, self)
    self.__index = self
    o.character = character
    o.pump = pump
    o.item = item
    o.maxTime = duration
    o.isTorch = isTorch
    o.stopOnWalk = true
    o.stopOnRun = true
    return o
end