----------------
--somewhatfrog--
----------------

local function updateSettings()
    local options = getSandboxOptions()
    options:set("ZombieLore.Speed", 4)

    local sandboxVars = SandboxVars.SWSprintersOverTime
    local increaseRate = sandboxVars.IncreaseRate
    local maxPercentage = sandboxVars.MaxPercentage
    local delay = sandboxVars.Delay
    local reverse = sandboxVars.Reverse

    local worldAge = IsoWorld.instance:getWorldAgeDays() - delay
    local sprinterPercentage = worldAge / increaseRate + 1
    if sprinterPercentage < 0 then sprinterPercentage = 0 elseif sprinterPercentage > maxPercentage then sprinterPercentage = maxPercentage end
    local roundedSP = sprinterPercentage - sprinterPercentage % 1
    if reverse then roundedSP = maxPercentage - roundedSP end
    options:set("ZombieLore.SprinterPercentage", roundedSP)
end
Events.EveryHours.Add(updateSettings)
Events.OnInitGlobalModData.Add(updateSettings)
