local ImmersiveBlackouts = {}

local DEBUG = false or getDebug()
ImmersiveBlackouts.Print = DEBUG and function(...) print(...) end or function() end

function ImmersiveBlackouts.SV()
	return (SandboxVars and SandboxVars.ImmersiveBlackouts) or {}
end

function ImmersiveBlackouts.GetBlackout()
	return ModData.getOrCreate("ImmersiveBlackouts")
end

function ImmersiveBlackouts.ForEachPlayer(callback)
	local players = isMultiplayer() and getOnlinePlayers() or IsoPlayer.getPlayers()
	for i = 0, players:size() - 1 do
		local player = players:get(i)
		if player then
			callback(player)
		end
	end
end

function ImmersiveBlackouts.getAllBuildingRooms(player)
	local square = player:getCurrentSquare()
	if not square then return {} end
	local building = square:getBuilding()
	if not building then return {} end
	local rooms = {}
	local seen = {}
	local cellRooms = player:getCell():getRoomList()
	if not cellRooms then return rooms end
	for i = 0, cellRooms:size() - 1 do
		local room = cellRooms:get(i)
		if room and room:getBuilding() == building and not seen[room] then
			seen[room] = true
			table.insert(rooms, room)
		end
	end
	return rooms
end

function ImmersiveBlackouts.getBuildingSwitches(player)
	local switches = {}
	for _, room in ipairs(ImmersiveBlackouts.getAllBuildingRooms(player)) do
		if room.hasLightSwitches then
			local lightSwitches = room:getLightSwitches()
			if lightSwitches then
				for j = 0, lightSwitches:size() - 1 do
					local sw = lightSwitches:get(j)
					if sw and sw:isActivated() then
						table.insert(switches, sw)
					end
				end
			end
		end
	end
	return switches
end

function ImmersiveBlackouts.PlaySoundShutoff(player)
	if not player:isOutside() then
		player:playSoundLocal("ImmersiveBlackouts_Flicker")
	end
end

return ImmersiveBlackouts
