if isClient() then return end
local IB = require "ImmersiveBlackouts_Utils"
ImmersiveBlackouts_isWaterShut = nil
ImmersiveBlackouts_isBlackout = nil

------------------------------------------------------
-- LIGHTS FLICKER
------------------------------------------------------------
local function SingleplayerFlicker(duration, minInterval, maxInterval)
	IB.ForEachPlayer(function(player)
		local switches = IB.getBuildingSwitches(player)
		if #switches == 0 then return end
		for _, sw in ipairs(switches) do
			local elapsed = 0
			local state = false
			local nextSwitch = ZombRandFloat(minInterval, maxInterval) or 0.1
			local function TickFlicker()
				elapsed = elapsed + getGameTime():getTimeDelta()
				if elapsed >= duration then
					sw:setActive(true, false, true)
					Events.OnTick.Remove(TickFlicker)
					return
				end
				if elapsed >= nextSwitch then
					state = not state
					sw:setActive(state, false, true)
					nextSwitch = elapsed + (ZombRandFloat(minInterval, maxInterval) or 0.1)
				end
			end
			Events.OnTick.Add(TickFlicker)
		end
	end)
end

local function MultiplayerFlicker(duration, minInterval, maxInterval)
	local seen = {}
	local switchesToFlicker = {}
	IB.ForEachPlayer(function(player)
		local switches = IB.getBuildingSwitches(player)
		for _, sw in ipairs(switches) do
			if not seen[sw] then
				seen[sw] = true
				table.insert(switchesToFlicker, {
					sw = sw,
					elapsed = 0,
					nextSwitch = ZombRandFloat(minInterval, maxInterval),
					state = false,
					duration = duration,
					minInterval = minInterval,
					maxInterval = maxInterval
				})
			end
		end
	end)
	if #switchesToFlicker == 0 then return end
	local function TickFlicker()
		local delta = getGameTime():getTimeDelta()
		local finished = true
		for _, fs in ipairs(switchesToFlicker) do
			fs.elapsed = fs.elapsed + delta
			if fs.elapsed < fs.duration then
				finished = false
				if fs.elapsed >= fs.nextSwitch then
					fs.state = not fs.state
					fs.sw:setActive(fs.state, false, true)
					fs.nextSwitch = fs.elapsed + ZombRandFloat(fs.minInterval, fs.maxInterval)
				end
			else
				fs.sw:setActive(true, false, true)
			end
		end
		if finished then
			Events.OnTick.Remove(TickFlicker)
		end
	end
	Events.OnTick.Add(TickFlicker)
end

------------------------------------------------------------
-- WATER & ELECTRICITY
------------------------------------------------------------
local function SyncSupply(resource, enable)
	if isServer() then
		if resource == "Water" then
			sendServerCommand("ImmersiveBlackouts", "SyncWaterShut", {value = SandboxVars.WaterShutModifier})
		elseif resource == "Electricity" then
			sendServerCommand("ImmersiveBlackouts", "SyncElecShut", {value = SandboxVars.ElecShutModifier})
			getWorld():setHydroPowerOn(enable)
			sendServerCommand("ImmersiveBlackouts", "SyncHydroPower", {enabled = enable})
		end
	else
		if resource == "Electricity" then
			getWorld():setHydroPowerOn(enable)
		end
	end
end

local function SetSupply(resource, enable)
	local blackout = IB.GetBlackout()
	local sandbox = getSandboxOptions()
	if resource == "Water" then
		if blackout.originalWaterShut then
			SandboxVars.WaterShutModifier = enable and blackout.originalWaterShut or 0
			sandbox:set("WaterShutModifier", enable and blackout.originalWaterShut or 0)
			sandbox:applySettings()
			SyncSupply(resource, enable)
		end
	elseif resource == "Electricity" then
		if blackout.originalElecShut then
			SandboxVars.ElecShutModifier = enable and blackout.originalElecShut or 0
			sandbox:set("ElecShutModifier", enable and blackout.originalElecShut or 0)
			sandbox:applySettings()
			SyncSupply(resource, enable)
		end
	end
end

local function ToggleWater()
	local sv = IB.SV()
	local blackout = IB.GetBlackout()
	if blackout.WaterOff then
		if ZombRand(100) < sv.WaterPercentON then
			blackout.WaterOff = false
			ImmersiveBlackouts_isWaterShut = false
			sendServerCommand("ImmersiveBlackouts", "SyncState", {waterOff = ImmersiveBlackouts_isWaterShut, elecOff = ImmersiveBlackouts_isBlackout})
			SetSupply("Water", true)
		end
	else
		if ZombRand(100) < sv.WaterPercentOFF then
			blackout.WaterOff = true
			ImmersiveBlackouts_isWaterShut = true
			sendServerCommand("ImmersiveBlackouts", "SyncState", {waterOff = ImmersiveBlackouts_isWaterShut, elecOff = ImmersiveBlackouts_isBlackout})
			SetSupply("Water", false)
		end
	end
end

local function ToggleElectricity()
	local sv = IB.SV()
	local blackout = IB.GetBlackout()
	if blackout.ElecOff then
		if ZombRand(100) < sv.ElectricityPercentON then
			blackout.ElecOff = false
			ImmersiveBlackouts_isBlackout = false
			sendServerCommand("ImmersiveBlackouts", "SyncState", {waterOff = ImmersiveBlackouts_isWaterShut, elecOff = ImmersiveBlackouts_isBlackout})
			SetSupply("Electricity", true)
		end
	else
		if ZombRand(100) < sv.ElectricityPercentOFF then
			blackout.ElecOff = true
			ImmersiveBlackouts_isBlackout = true
			sendServerCommand("ImmersiveBlackouts", "SyncState", {waterOff = ImmersiveBlackouts_isWaterShut, elecOff = ImmersiveBlackouts_isBlackout})
			local flickerDuration = 1.85
			local elapsed = 0
			local function DisableElectricity()
				elapsed = elapsed + getGameTime():getTimeDelta()
				if elapsed >= flickerDuration then
					SetSupply("Electricity", false)
					Events.OnTick.Remove(DisableElectricity)
				end
			end
			Events.OnTick.Add(DisableElectricity)
			if isServer() then
				sendServerCommand("ImmersiveBlackouts", "PlaySound", {})
			else
				setGameSpeed(1)
				IB.ForEachPlayer(function(player) IB.PlaySoundShutoff(player) end)
			end
			if sv.LightsFlickering then
				if isServer() then
					MultiplayerFlicker(flickerDuration, 0.05, 0.3)
				else
					SingleplayerFlicker(flickerDuration, 0.05, 0.3)
				end
			end
		end
	end
end

------------------------------------------------------------
-- EVENTS
------------------------------------------------------------
local function DisableSandboxOptions(resource)
	local sandbox = getSandboxOptions()
	if resource == "Water" then
		SandboxVars.ImmersiveBlackouts.WaterPercentOFF = 0
		SandboxVars.ImmersiveBlackouts.WaterPercentON = 0
		sandbox:set("ImmersiveBlackouts.WaterPercentOFF", 0)
		sandbox:set("ImmersiveBlackouts.WaterPercentON", 0)
	elseif resource == "Electricity" then
		SandboxVars.ImmersiveBlackouts.ElectricityPercentOFF = 0
		SandboxVars.ImmersiveBlackouts.ElectricityPercentON = 0
		sandbox:set("ImmersiveBlackouts.ElectricityPercentOFF", 0)
		sandbox:set("ImmersiveBlackouts.ElectricityPercentON", 0)
	end
	sandbox:applySettings()
end

local function RandomWater()
	local sv = IB.SV()
	local blackout = IB.GetBlackout()
	local currentDay = math.floor(getGameTime():getWorldAgeDaysSinceBegin())
	if blackout.originalWaterShut and currentDay >= blackout.originalWaterShut then
		blackout.WaterOff = false
		ImmersiveBlackouts_isWaterShut = false
		sendServerCommand("ImmersiveBlackouts", "SyncState", {waterOff = ImmersiveBlackouts_isWaterShut, elecOff = ImmersiveBlackouts_isBlackout})
		IB.Print("Removing Water")
		DisableSandboxOptions("Water")
		Events.EveryTenMinutes.Remove(RandomWater)
		return
	end
	if blackout.originalWaterShut then
		if sv.IgnoreStartDay or blackout.originalWaterShut - currentDay <= sv.StartDay then
			ToggleWater()
		end
	end
end

local function RandomElectricity()
	local sv = IB.SV()
	local blackout = IB.GetBlackout()
	local currentDay = math.floor(getGameTime():getWorldAgeDaysSinceBegin())
	if blackout.originalElecShut and currentDay >= blackout.originalElecShut then
		blackout.ElecOff = false
		ImmersiveBlackouts_isBlackout = false
		sendServerCommand("ImmersiveBlackouts", "SyncState", {waterOff = ImmersiveBlackouts_isWaterShut, elecOff = ImmersiveBlackouts_isBlackout})
		IB.Print("Removing Electricity")
		DisableSandboxOptions("Electricity")
		Events.EveryTenMinutes.Remove(RandomElectricity)
		return
	end
	if blackout.originalElecShut then
		if sv.IgnoreStartDay or blackout.originalElecShut - currentDay <= sv.StartDay then
			ToggleElectricity()
		end
	end
end

local function BlackoutsInit()
	local sv = IB.SV()
	local WaterShut = SandboxVars.WaterShutModifier
	local ElecShut = SandboxVars.ElecShutModifier
	local blackout = IB.GetBlackout()
	if WaterShut ~= 0 and WaterShut ~= -1 then
		blackout.originalWaterShut = WaterShut
	end
	if ElecShut ~= 0 and ElecShut ~= -1 then
		blackout.originalElecShut = ElecShut
	end
	if sv.WaterPercentON ~= 0 and sv.WaterPercentOFF ~= 0 then
		Events.EveryTenMinutes.Add(RandomWater)
	end
	if sv.ElectricityPercentON ~= 0 and sv.ElectricityPercentOFF ~= 0 then
		Events.EveryTenMinutes.Add(RandomElectricity)
	end
	Events.OnTick.Remove(BlackoutsInit)
end

local function onClientCommand(module, command, playerObj, args)
	if module ~= "ImmersiveBlackouts" then return end
	if command == "RequestState" then
		sendServerCommand(playerObj, "ImmersiveBlackouts", "SyncState", {waterOff = ImmersiveBlackouts_isWaterShut, elecOff = ImmersiveBlackouts_isBlackout})
	end
end

local function BlackoutsInit_GlobalModData(newGame)
	local blackout = IB.GetBlackout()
	if blackout.WaterOff == nil then blackout.WaterOff = false end
	if blackout.ElecOff == nil then blackout.ElecOff = false end
	if ImmersiveBlackouts_isWaterShut == nil then ImmersiveBlackouts_isWaterShut = blackout.WaterOff end
	if ImmersiveBlackouts_isBlackout == nil then ImmersiveBlackouts_isBlackout = blackout.ElecOff end
end

------------------------------------------------------------
-- EVENT REGISTRATION
------------------------------------------------------------
Events.OnTick.Add(BlackoutsInit)
Events.OnClientCommand.Add(onClientCommand)
Events.OnInitGlobalModData.Add(BlackoutsInit_GlobalModData)
