if not isClient() then return end
local IB = require "ImmersiveBlackouts_Utils"

local function onServerCommand(module, command, args)
	if module ~= "ImmersiveBlackouts" then return end
	IB.Print("ImmersiveBlackouts: onServerCommand " .. command)
	if command == "PlaySound" then
		IB.PlaySoundShutoff(getPlayer())
	elseif command == "SyncWaterShut" then
		SandboxVars.WaterShutModifier = args.value
		getSandboxOptions():set("WaterShutModifier", args.value)
	elseif command == "SyncElecShut" then
		SandboxVars.ElecShutModifier = args.value
		getSandboxOptions():set("ElecShutModifier", args.value)
	elseif command == "SyncHydroPower" then
		getWorld():setHydroPowerOn(args.enabled)
	elseif command == "SyncState" then
		ImmersiveBlackouts_isWaterShut = args.waterOff
		ImmersiveBlackouts_isBlackout = args.elecOff
	end
end

local function OnTick()
	if not getPlayer() then return end
	sendClientCommand("ImmersiveBlackouts", "RequestState", {})
	Events.OnTick.Remove(OnTick)
end

Events.OnServerCommand.Add(onServerCommand)
Events.OnTick.Add(OnTick)
