--        __     __                   
-- _|_   (_ ||\/|__) /\ _ _ _ _|   _  
--  |    __)||  |__)/--|_| (_(_||_|/_ 
--                     |               

require "ISUI/ISPanel"

local MOD_ID          = "SIMBAchanges"          -- id do mod para salvar CFG
local CONFIG_FILE     = "SIMBA_FPSOverlay.cfg"  -- arquivo de posição do FPS
local PANEL_WIDTH     = 43                      -- largura do painel
local PANEL_HEIGHT    = 38                      -- altura do painel
local FPS_FONT_NAME   = "Small"                 -- fonte do texto
local FPS_R           = 0.20                    -- cor R do texto
local FPS_G           = 1.00                    -- cor G do texto
local FPS_B           = 0.80                    -- cor B do texto
local FPS_A           = 1.00                    -- alpha do texto

local SIMBA_FPSOverlay = {
    savedX      = nil,
    savedY      = nil,
    instance    = nil,
    lastUpdate  = 0,
    frameCount  = 0,
    currentFPS  = 0,
}

local SIMBA_HUD_Config   = require("SIMBA_AUTOhide_menu")
local SIMBA_FPS_LastFlag = nil

local function SIMBA_FPSOverlay_loadPosition()
    local reader = getModFileReader(MOD_ID, CONFIG_FILE, false)
    if not reader then return end
    local line = reader:readLine()
    reader:close()
    if not line then return end
    local x, y = line:match("^(%-?%d+);(%-?%d+)$")
    if x and y then
        SIMBA_FPSOverlay.savedX = tonumber(x)
        SIMBA_FPSOverlay.savedY = tonumber(y)
    end
end

local function SIMBA_FPSOverlay_savePosition(x, y)
    local writer = getModFileWriter(MOD_ID, CONFIG_FILE, true, false)
    if not writer then return end
    writer:write(string.format("%d;%d", math.floor(x), math.floor(y)))
    writer:close()
end

SIMBA_FPSOverlayPanel = ISPanel:derive("SIMBA_FPSOverlayPanel")

function SIMBA_FPSOverlayPanel:new(x, y, w, h)
    local o = ISPanel:new(x, y, w, h)
    setmetatable(o, self)
    self.__index = self
    o.background = false
    o.borderColor = { r = 0, g = 0, b = 0, a = 0 }
    o.moveWithMouse = true
    o.dragging = false
    o.dragDX = 0
    o.dragDY = 0
    return o
end

function SIMBA_FPSOverlayPanel:initialise()
    ISPanel.initialise(self)
    self:setVisible(true)
    self:setAlwaysOnTop(true)
end

function SIMBA_FPSOverlayPanel:onMouseDown(x, y)
    self.dragging = true
    self.dragDX = x
    self.dragDY = y
    self:bringToTop()
    ISPanel.onMouseDown(self, x, y)
    return true
end

function SIMBA_FPSOverlayPanel:onMouseMove(dx, dy)
    if self.dragging then
        self:setX(self.x + dx)
        self:setY(self.y + dy)
    end
    ISPanel.onMouseMove(self, dx, dy)
end

function SIMBA_FPSOverlayPanel:onMouseMoveOutside(dx, dy)
    if self.dragging then
        self:setX(self.x + dx)
        self:setY(self.y + dy)
    end
    ISPanel.onMouseMoveOutside(self, dx, dy)
end

function SIMBA_FPSOverlayPanel:onMouseUp(x, y)
    self.dragging = false
    SIMBA_FPSOverlay_savePosition(self.x, self.y)
    ISPanel.onMouseUp(self, x, y)
    return true
end

function SIMBA_FPSOverlayPanel:onMouseUpOutside(x, y)
    self.dragging = false
    SIMBA_FPSOverlay_savePosition(self.x, self.y)
    ISPanel.onMouseUpOutside(self, x, y)
end

function SIMBA_FPSOverlayPanel:render()
    ISPanel.render(self)

    SIMBA_FPSOverlay.frameCount = SIMBA_FPSOverlay.frameCount + 1

    if getTimeInMillis then
        local now = getTimeInMillis()
        if SIMBA_FPSOverlay.lastUpdate == 0 then
            SIMBA_FPSOverlay.lastUpdate = now
        else
            local dt = now - SIMBA_FPSOverlay.lastUpdate
            if dt >= 500 then
                local frames = SIMBA_FPSOverlay.frameCount
                if frames > 0 and dt > 0 then
                    SIMBA_FPSOverlay.currentFPS = (frames * 1000.0) / dt
                end
                SIMBA_FPSOverlay.frameCount = 0
                SIMBA_FPSOverlay.lastUpdate = now
            end
        end
    end

    local fps = SIMBA_FPSOverlay.currentFPS
    if not fps or fps <= 0 then return end

    fps = math.floor(fps + 0.5)
    local text = tostring(fps)

    local font = UIFont[FPS_FONT_NAME] or UIFont.Small
    local tm = getTextManager()
    local textH = tm:getFontHeight(font)
    local cx = self.width / 2
    local cy = (self.height - textH) / 2

    self:drawTextCentre(text, cx, cy, FPS_R, FPS_G, FPS_B, FPS_A, font)
end

local function SIMBA_FPSOverlay_create()
    if SIMBA_FPSOverlay.instance then return end

    SIMBA_FPSOverlay_loadPosition()

    local core = getCore()
    if not core then return end

    local screenW = core:getScreenWidth()
    local screenH = core:getScreenHeight()

    local x = SIMBA_FPSOverlay.savedX or (screenW - PANEL_WIDTH - 10)
    local y = SIMBA_FPSOverlay.savedY or 40

    if x < 0 then x = 0 end
    if y < 0 then y = 0 end
    if x + PANEL_WIDTH > screenW then
        x = screenW - PANEL_WIDTH
    end
    if y + PANEL_HEIGHT > screenH then
        y = screenH - PANEL_HEIGHT
    end

    local panel = SIMBA_FPSOverlayPanel:new(x, y, PANEL_WIDTH, PANEL_HEIGHT)
    panel:initialise()
    panel:addToUIManager()
    panel:bringToTop()

    SIMBA_FPSOverlay.instance = panel
end

local function SIMBA_FPSOverlay_updateVisibility()
    local enabled = true
    if SIMBA_HUD_Config and SIMBA_HUD_Config.fpsOverlayEnabled ~= nil then
        enabled = SIMBA_HUD_Config.fpsOverlayEnabled
    end

    if enabled == SIMBA_FPS_LastFlag then
        return
    end

    SIMBA_FPS_LastFlag = enabled

    if enabled then
        SIMBA_FPSOverlay_create()
        if SIMBA_FPSOverlay.instance then
            SIMBA_FPSOverlay.instance:setVisible(true)
        end
    else
        if SIMBA_FPSOverlay.instance then
            SIMBA_FPSOverlay.instance:setVisible(false)
        end
    end
end

Events.OnGameStart.Add(SIMBA_FPSOverlay_updateVisibility)
Events.OnCreatePlayer.Add(function(playerIndex, player)
    SIMBA_FPSOverlay_updateVisibility()
end)
Events.OnPlayerUpdate.Add(SIMBA_FPSOverlay_updateVisibility)
