--        __     __                   
-- _|_   (_ ||\/|__) /\ _ _ _ _|   _  
--  |    __)||  |__)/--|_| (_(_||_|/_ 
--                     |              

local SIMBA_AIMguard = {
    isAiming   = false,
    wasAiming  = false,
    pressStart = nil,
}

local AIM_DELAY_MS = 150 

local function SIMBA_AIMguard_HideInventory()
    return
end

local function SIMBA_AIMguard_Update(player)
    local rmbDown = isMouseButtonDown(1) == true

    if not rmbDown then
        SIMBA_AIMguard.isAiming   = false
        SIMBA_AIMguard.wasAiming  = false
        SIMBA_AIMguard.pressStart = nil
        return
    end

    if not SIMBA_AIMguard.pressStart then
        if getTimeInMillis then
            SIMBA_AIMguard.pressStart = getTimeInMillis()
        else
            SIMBA_AIMguard.pressStart = 0
        end
    end

    local nowAiming = false

    if getTimeInMillis and SIMBA_AIMguard.pressStart then
        local now = getTimeInMillis()
        if now - SIMBA_AIMguard.pressStart >= AIM_DELAY_MS then
            nowAiming = true
        end
    else
        nowAiming = true
    end

    SIMBA_AIMguard.isAiming = nowAiming

    if nowAiming and not SIMBA_AIMguard.wasAiming then
        SIMBA_AIMguard_HideInventory()
    end

    SIMBA_AIMguard.wasAiming = nowAiming
end

function SIMBA_AIMguard.ShouldBlockHUD()
    return SIMBA_AIMguard.isAiming == true
end

Events.OnPlayerUpdate.Add(SIMBA_AIMguard_Update)

return SIMBA_AIMguard
