--        __     __                   
-- _|_   (_ ||\/|__) /\ _ _ _ _|   _  
--  |    __)||  |__)/--|_| (_(_||_|/_ 
--                     |              

local function SIMBA_NeatBuilding_ApplyPatch()

    if ISEntityUI then
        if type(ISEntityUI.players) ~= "table" then
            ISEntityUI.players = {}
            print("[SIMBA autoHIDE HUD] Inicializado ISEntityUI.players (compat Neat Building).")
        end
    end

    if not NB_BuildingPanel or not NB_BuildingPanel.SetDragItem then
        return
    end

    local originalSetDragItem = NB_BuildingPanel.SetDragItem

    local function SIMBA_NB_SetDragItem_Safe(item, playerNum)
        local windowKey = "BuildWindow"

        if not ISEntityUI or type(ISEntityUI.players) ~= "table" then
            return
        end

        local playerEntry = ISEntityUI.players[playerNum]
        if not playerEntry or not playerEntry.windows then
            return
        end

        local windowEntry = playerEntry.windows[windowKey]
        if not windowEntry or not windowEntry.instance then
            return
        end

        local instance = windowEntry.instance

        if item then
            instance.pin = false
            instance.isCollapse = true

            if instance.recipeListColumn then
                instance.recipeListColumn:setVisible(false)
            end
            if instance.spacingCloumn then
                instance.spacingCloumn:setVisible(false)
            end
            if instance.resizeWidget then
                instance.resizeWidget:setVisible(false)
            end
            if instance.BuildingInfoPanel then
                instance.BuildingInfoPanel:setVisible(false)
            end

            instance.tempadjWidth = instance:getWidth()
            instance.tempadjHeight = instance:getHeight()
            instance:calculateLayout(instance.categoryListWidth, instance.tempadjHeight)
        else
            instance.pin = true
        end
    end

    Events.SetDragItem.Remove(originalSetDragItem)
    NB_BuildingPanel.SetDragItem = SIMBA_NB_SetDragItem_Safe
    Events.SetDragItem.Add(NB_BuildingPanel.SetDragItem)

    print("[SIMBA autoHIDE HUD] Compat Neat Building aplicado (SetDragItem + players).")
end

Events.OnGameStart.Add(SIMBA_NeatBuilding_ApplyPatch)
