--        __     __                   
-- _|_   (_ ||\/|__) /\ _ _ _ _|   _  
--  |    __)||  |__)/--|_| (_(_||_|/_ 
--                     |              

local SIMBA_HUD_Config   = require("SIMBA_AUTOhide_menu")  -- tabela de opções do menu
local SIMBA_Speed_Last   = nil                             -- último estado de esconder/mostrar

local function SIMBA_Speed_SetVisible(visible)
    local sc = UIManager.getSpeedControls()
    if not sc then return end

    local tmp = UIElement:new()
    if sc.setVisible then
        tmp.setVisible(sc, visible)
    end

    local list = sc.getControls and sc:getControls()
    if list then
        for i = 0, list:size() - 1 do
            local btn = list:get(i)
            tmp.setVisible(btn, visible)
        end
    end
end

local function SIMBA_Speed_Update()
    local hide = false

    if SIMBA_HUD_Config and SIMBA_HUD_Config.speedPanelFullHide ~= nil then
        hide = SIMBA_HUD_Config.speedPanelFullHide
    end

    if SIMBA_Speed_Last == hide then
        return
    end

    SIMBA_Speed_Last = hide
    SIMBA_Speed_SetVisible(not hide)
end

Events.OnGameStart.Add(SIMBA_Speed_Update)
Events.OnCreatePlayer.Add(function(playerIndex, player)
    SIMBA_Speed_Update()
end)
Events.OnPlayerUpdate.Add(SIMBA_Speed_Update)
Events.OnResolutionChange.Add(SIMBA_Speed_Update)
