--        __     __                   
-- _|_   (_ ||\/|__) /\ _ _ _ _|   _  
--  |    __)||  |__)/--|_| (_(_||_|/_ 
--                     |              

local EDGE_SHOW_X   = 2    -- distância da borda esquerda (px) para ativar a barra
local EDGE_HIDE_X   = 320  -- distância da borda esquerda (px) para desativar a barra
local ANIM_BASE_SPEED  = 2    -- velocidade mínima (px por tick)
local ANIM_EXTRA_SPEED = 26   -- aceleração extra da animação
local ANIM_EASE_POWER  = 2    -- curva da animação (2 = suave, 3 = mais agressiva)

local SIMBA_LeftSidebar = {
    visible = false,
    uiState = {}
}

local SIMBA_HUD_Config = require("SIMBA_AUTOhide_menu")
local SIMBA_AIMguard   = require("SIMBA_AUTOhide_AIMguard")


local function SIMBA_LeftSidebar_OptionEnabled()
    if SIMBA_HUD_Config and SIMBA_HUD_Config.leftSidebarAutoHide ~= nil then
        return SIMBA_HUD_Config.leftSidebarAutoHide
    end
    return true
end

local function isLeftSidebar(ui)
    if ui == nil then return false end
    if not ui.getX or not ui.getY or not ui.getWidth or not ui.getHeight then
        return false
    end

    local x = ui:getX()
    local y = ui:getY()
    local w = ui:getWidth()
    local h = ui:getHeight()

    if x < 20 and y < 60 and w > 10 and w < 120 and h > 40 then
        return true
    end

    return false
end

local function getSidebarState(ui)
    local state = SIMBA_LeftSidebar.uiState[ui]
    if not state then
        local x = ui:getX()
        local w = ui:getWidth()

        local visibleX = x
        local hiddenX  = x - w + 4

        state = {
            visibleX = visibleX,
            hiddenX  = hiddenX,
            currentX = hiddenX
        }

        ui:setX(hiddenX)
        ui:setVisible(false)

        SIMBA_LeftSidebar.uiState[ui] = state
    end
    return state
end

local function animateSidebar(ui, wantVisible)
    local state = getSidebarState(ui)
    local targetX = wantVisible and state.visibleX or state.hiddenX
    local curX    = state.currentX

    if wantVisible then
        ui:setVisible(true)
    end

    if curX == targetX then
        if not wantVisible then
            ui:setVisible(false)
        end
        return
    end

    local totalDist    = math.abs(state.visibleX - state.hiddenX)
    local distToTarget = math.abs(targetX - curX)

    local step
    if totalDist > 0 then
        local progress = 1.0 - (distToTarget / totalDist)
        if progress < 0 then progress = 0 end
        if progress > 1 then progress = 1 end

        local speedFactor = progress ^ ANIM_EASE_POWER
        step = ANIM_BASE_SPEED + ANIM_EXTRA_SPEED * speedFactor
    else
        step = ANIM_BASE_SPEED
    end

    if curX < targetX then
        curX = math.min(curX + step, targetX)
    else
        curX = math.max(curX - step, targetX)
    end

    state.currentX = curX
    ui:setX(curX)

    if (not wantVisible) and curX == state.hiddenX then
        ui:setVisible(false)
    end
end

local function updateLeftSidebar(player)
    if not getPlayer() then return end

    local uis = UIManager.getUI()
    if not uis then return end

    if SIMBA_AIMguard and SIMBA_AIMguard.ShouldBlockHUD and SIMBA_AIMguard.ShouldBlockHUD() then
        SIMBA_LeftSidebar.visible = false
        for i = 0, uis:size() - 1 do
            local ui = uis:get(i)
            if isLeftSidebar(ui) then
                animateSidebar(ui, false)
            end
        end
        return
    end

    if not SIMBA_LeftSidebar_OptionEnabled() then
        for i = 0, uis:size() - 1 do
            local ui = uis:get(i)
            if isLeftSidebar(ui) then
                local state = SIMBA_LeftSidebar.uiState[ui]
                if state and state.visibleX then
                    ui:setX(state.visibleX)
                end
                ui:setVisible(true)
            end
        end
        return
    end

    local mx = getMouseX()
    local visible = SIMBA_LeftSidebar.visible

    if mx <= EDGE_SHOW_X then
        visible = true
    elseif mx >= EDGE_HIDE_X then
        visible = false
    end

    SIMBA_LeftSidebar.visible = visible

    for i = 0, uis:size() - 1 do
        local ui = uis:get(i)
        if isLeftSidebar(ui) then
            animateSidebar(ui, visible)
        end
    end
end


Events.OnPlayerUpdate.Add(updateLeftSidebar)
