--        __     __                   
-- _|_   (_ ||\/|__) /\ _ _ _ _|   _  
--  |    __)||  |__)/--|_| (_(_||_|/_ 
--                     |              

local config = {}

local DEFAULT_LEFT_SIDEBAR = true   
local DEFAULT_BOTTOM_BAR   = true   
local DEFAULT_INVENTORY    = true  
local DEFAULT_SPEED_PANEL  = true   
local DEFAULT_FPS_OVERLAY  = true   

local function buildOptions()
    local sectionTitle = getText("autoHIDE HUD")

    local options = PZAPI.ModOptions:create("SIMBAautoHIDEhud", sectionTitle)

    local labelLeft   = getText("UI_SIMBA_AutoHide_Left_Label")
    local labelBottom = getText("UI_SIMBA_AutoHide_Bottom_Label")
    local labelInv    = getText("UI_SIMBA_AutoHide_Inventory_Label")
    local labelSpeed  = getText("UI_SIMBA_AutoHide_Speed_Label")
    local labelFPS    = getText("UI_SIMBA_AutoHide_FPS_Label")

    local descLeft    = getText("UI_SIMBA_AutoHide_Left_Desc")
    local descBottom  = getText("UI_SIMBA_AutoHide_Bottom_Desc")
    local descInv     = getText("UI_SIMBA_AutoHide_Inventory_Desc")
    local descSpeed   = getText("UI_SIMBA_AutoHide_Speed_Desc")
    local descFPS     = getText("UI_SIMBA_AutoHide_FPS_Desc")

    options:addTickBox("leftSidebarAutoHide",  labelLeft,   DEFAULT_LEFT_SIDEBAR,  descLeft)
    options:addTickBox("bottomBarAutoHide",    labelBottom, DEFAULT_BOTTOM_BAR,    descBottom)
    options:addTickBox("inventoryAutoHide",    labelInv,    DEFAULT_INVENTORY,     descInv)
    options:addTickBox("speedPanelFullHide",   labelSpeed,  DEFAULT_SPEED_PANEL,   descSpeed)
    options:addTickBox("fpsOverlayEnabled",    labelFPS,    DEFAULT_FPS_OVERLAY,   descFPS)

    options.applyInGame = true

    options.apply = function(self)
        for k, v in pairs(self.dict) do
            if v.type == "multipletickbox" then
                for i = 1, #v.values do
                    config[k .. "_" .. tostring(i)] = v:getValue(i)
                end
            elseif v.type ~= "button" then
                config[k] = v:getValue()
            end
        end
    end

    return options
end

local SIMBA_Options = buildOptions()

local function SIMBA_ApplyOptions()
    SIMBA_Options:apply()
end

Events.OnMainMenuEnter.Add(SIMBA_ApplyOptions)
Events.OnGameStart.Add(SIMBA_ApplyOptions)
Events.OnCreatePlayer.Add(SIMBA_ApplyOptions)
Events.OnPlayerUpdate.Add(SIMBA_ApplyOptions)

return config
