--        __     __                   
-- _|_   (_ ||\/|__) /\ _ _ _ _|   _  
--  |    __)||  |__)/--|_| (_(_||_|/_ 
--                     |              

local SIMBA_HUD_Config = require("SIMBA_AUTOhide_menu")
local SIMBA_AIMguard   = require("SIMBA_AUTOhide_AIMguard")


local SIMBA_InventoryHUD = {
    player = {
        visible           = true,
        aimStoredVisible  = nil,  
    },
    loot = {
        visible           = true,
        lastInv           = nil,
        lastCount         = -1,
        aimStoredVisible  = nil,  
    }
}


local function SIMBA_Inventory_OptionEnabled()
    if SIMBA_HUD_Config and SIMBA_HUD_Config.inventoryAutoHide ~= nil then
        return SIMBA_HUD_Config.inventoryAutoHide
    end
    return true
end

local function SIMBA_Inventory_GetLootInventoryAndCount(lootUI)
    if not lootUI or not lootUI.inventoryPane then
        return nil, 0
    end

    local inv = lootUI.inventoryPane.inventory
    if not inv or not inv.getItems then
        return inv, 0
    end

    local items = inv:getItems()
    if not items then
        return inv, 0
    end

    return inv, items:size()
end

local function SIMBA_Inventory_IsInsideRect(ui, mx, my)
    if not ui then
        return false
    end

    local ux = ui:getX()
    local uy = ui:getY()
    local uw = ui:getWidth()
    local uh = ui:getHeight()

    return mx >= ux and mx <= ux + uw and my >= uy and my <= uy + uh
end

local function updateInventoryAutoHide(player)
    local p = player or getSpecificPlayer(0)
    if not p or p:isDead() then
        return
    end

    local playerIndex = p:getPlayerNum()
    local invUI  = getPlayerInventory(playerIndex)
    local lootUI = getPlayerLoot(playerIndex)

    if not invUI and not lootUI then
        return
    end

    local isBlockingHUD = SIMBA_AIMguard
        and SIMBA_AIMguard.ShouldBlockHUD
        and SIMBA_AIMguard.ShouldBlockHUD()

    if isBlockingHUD then

        if invUI then
            if SIMBA_InventoryHUD.player.aimStoredVisible == nil then
                SIMBA_InventoryHUD.player.aimStoredVisible = invUI:isVisible()
            end
            invUI:setVisible(false)
        end

        if lootUI then
            if SIMBA_InventoryHUD.loot.aimStoredVisible == nil then
                SIMBA_InventoryHUD.loot.aimStoredVisible = lootUI:isVisible()
            end
            lootUI:setVisible(false)
        end

        return
    else

        if not SIMBA_Inventory_OptionEnabled() then
            if invUI and SIMBA_InventoryHUD.player.aimStoredVisible ~= nil then
                invUI:setVisible(SIMBA_InventoryHUD.player.aimStoredVisible)
            end

            if lootUI and SIMBA_InventoryHUD.loot.aimStoredVisible ~= nil then
                lootUI:setVisible(SIMBA_InventoryHUD.loot.aimStoredVisible)
            end

            SIMBA_InventoryHUD.player.aimStoredVisible = nil
            SIMBA_InventoryHUD.loot.aimStoredVisible   = nil
            return
        end

        SIMBA_InventoryHUD.player.aimStoredVisible = nil
        SIMBA_InventoryHUD.loot.aimStoredVisible   = nil
    end


    if not SIMBA_Inventory_OptionEnabled() then
        return
    end

    local mx = getMouseX()
    local my = getMouseY()

    if invUI then
        local overInv = SIMBA_Inventory_IsInsideRect(invUI, mx, my)
        if overInv then
            SIMBA_InventoryHUD.player.visible = true
            if not invUI:isVisible() then
                invUI:setVisible(true)
            end
        end
    end

    if lootUI then
        local overLoot = SIMBA_Inventory_IsInsideRect(lootUI, mx, my)
        local inv, count = SIMBA_Inventory_GetLootInventoryAndCount(lootUI)
        local lastInv   = SIMBA_InventoryHUD.loot.lastInv
        local lastCount = SIMBA_InventoryHUD.loot.lastCount or -1

        if lootUI:isVisible() then
            SIMBA_InventoryHUD.loot.visible = true
        end

        if overLoot then
            SIMBA_InventoryHUD.loot.visible = true
        end

        if inv then
            if (inv ~= lastInv and count > 0) or (count > lastCount) then
                SIMBA_InventoryHUD.loot.visible = true
            end
        end

        SIMBA_InventoryHUD.loot.lastInv   = inv
        SIMBA_InventoryHUD.loot.lastCount = count

        if SIMBA_InventoryHUD.loot.visible and not lootUI:isVisible() then
            lootUI:setVisible(true)
        end
    end
end



local function SIMBA_Inventory_OnMouseDown(x, y)
    if SIMBA_AIMguard and SIMBA_AIMguard.ShouldBlockHUD and SIMBA_AIMguard.ShouldBlockHUD() then
        local p = getSpecificPlayer(0)
        if p and not p:isDead() then
            local playerIndex = p:getPlayerNum()
            local invUI  = getPlayerInventory(playerIndex)
            local lootUI = getPlayerLoot(playerIndex)

            if invUI then
                SIMBA_InventoryHUD.player.visible = false
                invUI:setVisible(false)
            end

            if lootUI then
                SIMBA_InventoryHUD.loot.visible = false
                lootUI:setVisible(false)
            end
        end
        return
    end

    if not SIMBA_Inventory_OptionEnabled() then
        return
    end

    local p = getSpecificPlayer(0)
    if not p or p:isDead() then
        return
    end

    local playerIndex = p:getPlayerNum()
    local invUI  = getPlayerInventory(playerIndex)
    local lootUI = getPlayerLoot(playerIndex)

    local insideInv  = invUI  and SIMBA_Inventory_IsInsideRect(invUI,  x, y)
    local insideLoot = lootUI and SIMBA_Inventory_IsInsideRect(lootUI, x, y)

    if insideInv or insideLoot then
        if insideInv and invUI then
            SIMBA_InventoryHUD.player.visible = true
            if not invUI:isVisible() then
                invUI:setVisible(true)
            end
        end
        if insideLoot and lootUI then
            SIMBA_InventoryHUD.loot.visible = true
            if not lootUI:isVisible() then
                lootUI:setVisible(true)
            end
        end
        return
    end

    if invUI then
        SIMBA_InventoryHUD.player.visible = false
        invUI:setVisible(false)
    end

    if lootUI then
        SIMBA_InventoryHUD.loot.visible = false
        lootUI:setVisible(false)
    end
end



Events.OnMouseDown.Add(SIMBA_Inventory_OnMouseDown)
Events.OnPlayerUpdate.Add(updateInventoryAutoHide)

