--        __     __                   
-- _|_   (_ ||\/|__) /\ _ _ _ _|   _  
--  |    __)||  |__)/--|_| (_(_||_|/_
--                     |                      

local BOTTOM_SHOW_Y      = 2      -- distância da borda de baixo (em px) para ATIVAR a barra
local BOTTOM_HIDE_Y      = 120    -- distância da borda de baixo (em px) para DESATIVAR a barra
local CENTER_TOLERANCE   = 260    -- tolerância em px em relação ao centro da tela

local ANIM_BASE_SPEED    = 2      -- velocidade mínima (px por tick)
local ANIM_EXTRA_SPEED   = 26     -- quanto acelera até o final
local ANIM_EASE_POWER    = 2      -- curva: 2 = suave, 3 = mais agressivo

local SIMBA_BottomHUD = {
    visible = false,
    uiState = {}
}

local SIMBA_HUD_Config = require("SIMBA_AUTOhide_menu")
local SIMBA_AIMguard   = require("SIMBA_AUTOhide_AIMguard")


local function SIMBA_BottomHUD_OptionEnabled()
    if SIMBA_HUD_Config and SIMBA_HUD_Config.bottomBarAutoHide ~= nil then
        return SIMBA_HUD_Config.bottomBarAutoHide
    end
    return true
end


local function isBottomHotbar(ui)
    if ui == nil then return false end
    if not ui.getX or not ui.getY or not ui.getWidth or not ui.getHeight then
        return false
    end

    local core = getCore()
    if not core then return false end

    local screenW = core:getScreenWidth()
    local screenH = core:getScreenHeight()

    local x = ui:getX()
    local y = ui:getY()
    local w = ui:getWidth()
    local h = ui:getHeight()

    local cx = x + w / 2
    local centerX = screenW / 2

    if y < screenH - 140 then
        return false
    end

    if h < 24 or h > 120 then
        return false
    end
    if w < 160 then
        return false
    end

    if math.abs(cx - centerX) > CENTER_TOLERANCE then
        return false
    end

    return true
end

local function getBottomState(ui)
    local state = SIMBA_BottomHUD.uiState[ui]
    if not state then
        local y = ui:getY()
        local h = ui:getHeight()

        local visibleY = y
        local hiddenY  = y + h - 4   

        state = {
            visibleY = visibleY,
            hiddenY  = hiddenY,
            currentY = hiddenY
        }

        ui:setY(hiddenY)
        ui:setVisible(false)

        SIMBA_BottomHUD.uiState[ui] = state
    end
    return state
end

local function animateBottomHUD(ui, wantVisible)
    local state = getBottomState(ui)
    local targetY = wantVisible and state.visibleY or state.hiddenY
    local curY    = state.currentY

    if wantVisible then
        ui:setVisible(true)
    end

    if curY == targetY then
        if not wantVisible then
            ui:setVisible(false)
        end
        return
    end

    local totalDist = math.abs(state.visibleY - state.hiddenY)
    local distToTarget = math.abs(targetY - curY)

    local step
    if totalDist > 0 then
        local progress = 1.0 - (distToTarget / totalDist)
        if progress < 0 then progress = 0 end
        if progress > 1 then progress = 1 end

        local speedFactor = progress ^ ANIM_EASE_POWER
        step = ANIM_BASE_SPEED + ANIM_EXTRA_SPEED * speedFactor
    else
        step = ANIM_BASE_SPEED
    end

    if curY < targetY then
        curY = math.min(curY + step, targetY)
    else
        curY = math.max(curY - step, targetY)
    end

    state.currentY = curY
    ui:setY(curY)

    if (not wantVisible) and curY == state.hiddenY then
        ui:setVisible(false)
    end
end

local function updateBottomHUD(player)
    if not getPlayer() then return end

    local core = getCore()
    if not core then return end

    local uis = UIManager.getUI()
    if not uis then return end

    if SIMBA_AIMguard and SIMBA_AIMguard.ShouldBlockHUD and SIMBA_AIMguard.ShouldBlockHUD() then
        SIMBA_BottomHUD.visible = false
        for i = 0, uis:size() - 1 do
            local ui = uis:get(i)
            if isBottomHotbar(ui) then
                animateBottomHUD(ui, false)
            end
        end
        return
    end

    if not SIMBA_BottomHUD_OptionEnabled() then
        for i = 0, uis:size() - 1 do
            local ui = uis:get(i)
            if isBottomHotbar(ui) then
                local state = SIMBA_BottomHUD.uiState[ui]
                if state and state.visibleY then
                    ui:setY(state.visibleY)
                end
                ui:setVisible(true)
            end
        end
        return
    end

    local screenH = core:getScreenHeight()
    local my = getMouseY()

    if my >= screenH - BOTTOM_SHOW_Y then
        SIMBA_BottomHUD.visible = true
    elseif my <= screenH - BOTTOM_HIDE_Y then
        SIMBA_BottomHUD.visible = false
    end

    local visible = SIMBA_BottomHUD.visible

    for i = 0, uis:size() - 1 do
        local ui = uis:get(i)
        if isBottomHotbar(ui) then
            animateBottomHUD(ui, visible)
        end
    end
end



Events.OnPlayerUpdate.Add(updateBottomHUD)
