--===================================================================
-- Data tables only (types, strings, thresholds, rates)
--===================================================================

if not RWC then RWC = {} end

-- Detect coolers ONLY by script fullType (robust against renamed items)
RWC.CoolerTypes = {
    ["Base.Cooler"]        = true,
    ["Base.Cooler_Beer"]   = true,
    ["Base.Cooler_Meat"]   = true,
    ["Base.Cooler_Seafood"]= true,
    ["Base.Cooler_Soda"]   = true,
}

-- Detect cold packs by type
RWC.ColdPackTypes = {
    ["Base.Coldpack"] = true,
}

-- Name suffixes (can be later localized)
RWC.Suffix = {
    Cooler = {
        VeryCold = " (Very Cold)",
        Cold     = " (Cold)",
        Cool     = " (Cool)",
        Warm     = " (Warm)",
    },
    ColdPack = {
        Warm    = " (Warm)",
        Cool    = " (Cool)",
        Chilled = " (Chilled)",
        Icy     = " (Icy)",
        Frozen  = " (Frozen)",
    }
}

-- Used only for suffix display
RWC.ColdPackBatteryStates = {
  { 80.0, "Frozen"  }, 
  { 60.0, "Icy"     }, 
  { 40.0, "Chilled" }, 
  { 20.0, "Cool"    }, 
  {  0.0, "Warm"    }, 
}

-- Used purely for display
RWC.CoolerStateByTemp = {
    { 75.0, "VeryCold" }, 
    { 50.0, "Cold"     }, 
    { 25.0, "Cool"     }, 
    {  0.0, "Warm"     }, 
}

-- ======= Thermo coefficients (simple, tweakable) ===================
RWC.Rates = {
  -- cold packs / change per world min 
  FreezerTargetBattery  = 100.0,
  FreezerApproachPerMin = 1.2,  
  FridgeTargetBattery   = 50.0,
  FridgeApproachPerMin  = 0.8,
  AmbientTargetBattery  = 0.0,
  AmbientApproachPerMin = 1.6,  

  -- coolers / change per world min
  ColdBatteryBleedRate    = 0.01,  -- battery lost per min naturally in coolers
  ColdBatteryNudgeRate    = 0.25, 
  ColdBatteryDrainPerHeat = 1.0,   -- how much battery per 1.0 Heat delta per 1.0 weight per minute
  ColdPackBattMassMult    = 4.0,   -- energy storage density in 1 mass of battery vs 1 mass of food
  FoodNudgeRate           = 2.0,  -- needs to be strong enough to overpower vanilla drain outside of fridge
}

-- cold pack location types
RWC.Storage = {
  AMBIENT = 0,
  COOLER  = 1,
  FRIDGE  = 2,
  FREEZER = 3,
}

-- Cold packs: coarse updates
RWC.ColdPackRegistry = {}        -- indexed in order
RWC.ColdPackRegistryCount = 0   -- size of registry

--RWC.ColdPackTickMinutes = 1      -- every in-game minute

-- Cooler ticking:
RWC.CoolerRegistry = {}          -- indexed in order
RWC.CoolerRegistryCount = 0      -- size of registry
--RWC.CoolerIterPos = 1            -- Rotation index: which array slot to process next

--RWC.CoolerTickInterval  = 5      -- call RWC_TickCoolerRegistry every OnTick
--RWC.CoolerTickBatchSize = 1      -- process 1 cooler per call
--RWC.CoolerCycleWaitTicks = 10    -- min number of ticks before restarting registry cycle

