--===================================================================
-- RealisticWorkingCoolers.lua
-- Entry point + scheduler + world scanning
--===================================================================

-- Create namespace only if not already defined (safe on reload)
if not RWC then RWC = {} end

-- Version & debug flags
RWC.version = 0.9
RWC.DEBUG   = false         -- Master debug toggle (module files also check SandboxVars)
RWC.DEBUG_CP   = false         -- debug for all cold packs 
RWC.REALTIME_DEBUG = false  -- For heavy tick-interval tracing (thermal stages)
RWC.TOOLTIP_DEBUG = false

print(string.format("[RWC %s] Initializing Real Working Cooler system...", RWC.version))

require "RWC_Data"        -- strings
require "RWC_Utility"     -- helper functions
require "RWC_Hook"        -- entry point for code
require "RWC_ColdPack"    -- logic for cold packs
require "RWC_Cooler"      -- logic for coolers
require "RWC_Tooltip"     -- debug to figure out food heat

print(string.format("[RWC %s] Real Working Cooler core boot complete.", RWC.version))
