local function addItemToDistribution(listName, fullType, weight)
    local distribution = ProceduralDistributions.list[listName]
    if not distribution or not distribution.items then
        return
    end

    local items = distribution.items
    for i = 1, #items, 2 do
        if items[i] == fullType then
            items[i + 1] = weight
            return
        end
    end

    table.insert(items, fullType)
    table.insert(items, weight)
end

-- Electric space heater (taller unit)
addItemToDistribution("ElectronicStoreAppliances", "RC_TempSimMod.Mov_RCElectricHeater1", 8)
addItemToDistribution("GigamartHouseElectronics", "RC_TempSimMod.Mov_RCElectricHeater1", 2)
addItemToDistribution("CrateElectronics", "RC_TempSimMod.Mov_RCElectricHeater1", 0.5)
addItemToDistribution("GarageTools", "RC_TempSimMod.Mov_RCElectricHeater1", 2)
addItemToDistribution("GarageMechanics", "RC_TempSimMod.Mov_RCElectricHeater1", 0.6)
addItemToDistribution("CrateTools", "RC_TempSimMod.Mov_RCElectricHeater1", 0.4)
addItemToDistribution("CrateCarpentry", "RC_TempSimMod.Mov_RCElectricHeater1", 0.3)
addItemToDistribution("CrateMetalwork", "RC_TempSimMod.Mov_RCElectricHeater1", 0.3)
addItemToDistribution("ClosetShelfGeneric", "RC_TempSimMod.Mov_RCElectricHeater1", 0.2)
addItemToDistribution("GardenStoreTools", "RC_TempSimMod.Mov_RCElectricHeater1", 0.3)

-- Compact electric space heater
addItemToDistribution("ElectronicStoreAppliances", "RC_TempSimMod.Mov_RCElectricHeater2", 8)
addItemToDistribution("GigamartHouseElectronics", "RC_TempSimMod.Mov_RCElectricHeater2", 3)
addItemToDistribution("CrateElectronics", "RC_TempSimMod.Mov_RCElectricHeater2", 2)
addItemToDistribution("GarageTools", "RC_TempSimMod.Mov_RCElectricHeater2", 1.2)
addItemToDistribution("GarageMechanics", "RC_TempSimMod.Mov_RCElectricHeater2", 2)
addItemToDistribution("CrateTools", "RC_TempSimMod.Mov_RCElectricHeater2", 0.6)
addItemToDistribution("CrateCarpentry", "RC_TempSimMod.Mov_RCElectricHeater2", 0.5)
addItemToDistribution("CrateMetalwork", "RC_TempSimMod.Mov_RCElectricHeater2", 0.5)
addItemToDistribution("ClosetShelfGeneric", "RC_TempSimMod.Mov_RCElectricHeater2", 0.3)
addItemToDistribution("GardenStoreTools", "RC_TempSimMod.Mov_RCElectricHeater2", 0.4)

-- Portable gas space heater
addItemToDistribution("CampingStoreLighting", "RC_TempSimMod.Mov_RCGasHeater", 4)
addItemToDistribution("SafehouseLighting", "RC_TempSimMod.Mov_RCGasHeater", 3)
addItemToDistribution("SafehouseLighting_Late", "RC_TempSimMod.Mov_RCGasHeater", 1)
addItemToDistribution("CratePropane", "RC_TempSimMod.Mov_RCGasHeater", 0.5)
addItemToDistribution("GarageTools", "RC_TempSimMod.Mov_RCGasHeater", 3)
addItemToDistribution("GarageMechanics", "RC_TempSimMod.Mov_RCGasHeater", 0.5)
addItemToDistribution("CrateCamping", "RC_TempSimMod.Mov_RCGasHeater", 2)
addItemToDistribution("CrateTools", "RC_TempSimMod.Mov_RCGasHeater", 0.4)
addItemToDistribution("CrateCarpentry", "RC_TempSimMod.Mov_RCGasHeater", 0.3)
addItemToDistribution("CrateMetalwork", "RC_TempSimMod.Mov_RCGasHeater", 0.3)
addItemToDistribution("GardenStoreTools", "RC_TempSimMod.Mov_RCGasHeater", 0.5)

return true
