--***********************************************************
--**                REALISTIC COLD - HEATER UI             **
--***********************************************************

require "TimedActions/ISBaseTimedAction"

local RCHeaters = require("RC_Heaters")

RCHeaterUITimedAction = ISBaseTimedAction:derive("RCHeaterUITimedAction")

function RCHeaterUITimedAction:isValid()
    return true
end

function RCHeaterUITimedAction:update()
    if self.object and self.object.getSquare and self.object:getSquare() then
        self.character:faceThisObject(self.object)
    end
end

function RCHeaterUITimedAction:start()
end

function RCHeaterUITimedAction:stop()
    ISBaseTimedAction.stop(self)
end

function RCHeaterUITimedAction:perform()
    ISBaseTimedAction.perform(self)

    if RCHeaters and RCHeaters.openHeaterUI then
        RCHeaters.openHeaterUI(self.character, self.object, self.info)
    end
end

function RCHeaterUITimedAction:new(character, object, info)
    local o = ISBaseTimedAction.new(self, character)
    o.object = object
    o.info = info
    o.maxTime = 0
    return o
end

return RCHeaterUITimedAction
