require("TimedActions/ISDrinkFromBottle")
require("TimedActions/ISDrinkFluidAction")

local function _applyCoolingFromDrink(character, thirstDelta)
    if not character or not thirstDelta or thirstDelta <= 0 then return end
    if not RC_TempSim or not RC_TempSim.applyDrinkCooling then return end
    RC_TempSim.applyDrinkCooling(character, thirstDelta)
end

if ISDrinkFromBottle and not ISDrinkFromBottle._RC_OriginalDrink then
    ISDrinkFromBottle._RC_OriginalDrink = ISDrinkFromBottle.drink
    function ISDrinkFromBottle:drink(food, percentage)
        local stats = self.character and self.character.getStats and self.character:getStats() or nil
        local before = stats and stats.getThirst and stats:getThirst() or nil
        ISDrinkFromBottle._RC_OriginalDrink(self, food, percentage)
        if before and stats and stats.getThirst then
            local after = stats:getThirst()
            local delta = before - after
            if delta and delta > 0 then
                _applyCoolingFromDrink(self.character, delta)
            end
        end
    end
end

local function _ensureFluidActionHooks()
    if not ISDrinkFluidAction then return end

    if not ISDrinkFluidAction._RC_OriginalStart then
        ISDrinkFluidAction._RC_OriginalStart = ISDrinkFluidAction.start
        function ISDrinkFluidAction:start()
            self._rcThirstAccum = 0
            self._rcCoolingApplied = false
            return ISDrinkFluidAction._RC_OriginalStart(self)
        end
    end

    if not ISDrinkFluidAction._RC_OriginalUpdateEat then
        ISDrinkFluidAction._RC_OriginalUpdateEat = ISDrinkFluidAction.updateEat
        function ISDrinkFluidAction:updateEat(delta)
            local stats = self.character and self.character.getStats and self.character:getStats() or nil
            local before = stats and stats.getThirst and stats:getThirst() or nil
            ISDrinkFluidAction._RC_OriginalUpdateEat(self, delta)
            if before and stats and stats.getThirst then
                local after = stats:getThirst()
                local diff = before - after
                if diff and diff > 0 then
                    self._rcThirstAccum = (self._rcThirstAccum or 0) + diff
                end
            end
        end
    end

    local function applyAccumulated(self)
        if not self or self._rcCoolingApplied then return end
        local total = self._rcThirstAccum or 0
        if total and total > 0 then
            _applyCoolingFromDrink(self.character, total)
        end
        self._rcCoolingApplied = true
        self._rcThirstAccum = 0
    end

    if not ISDrinkFluidAction._RC_OriginalStop then
        ISDrinkFluidAction._RC_OriginalStop = ISDrinkFluidAction.stop
        function ISDrinkFluidAction:stop()
            ISDrinkFluidAction._RC_OriginalStop(self)
            applyAccumulated(self)
        end
    end

    if not ISDrinkFluidAction._RC_OriginalPerform then
        ISDrinkFluidAction._RC_OriginalPerform = ISDrinkFluidAction.perform
        function ISDrinkFluidAction:perform()
            ISDrinkFluidAction._RC_OriginalPerform(self)
            applyAccumulated(self)
        end
    end
end

_ensureFluidActionHooks()
