require "ISUI/ISUIElement"
local RC_DigitalWatchUI = require "RC_DigitalWatch/RC_DigitalWatchUI"

local function removeExisting()
    if RC_DigitalWatchUI.instance then
        if RC_DigitalWatchUI.instance.restoreVanillaClock then
            RC_DigitalWatchUI.instance:restoreVanillaClock()
        end
        RC_DigitalWatchUI.instance:removeFromUIManager()
        RC_DigitalWatchUI.instance = nil
    end
end

function RC_DigitalWatchUI.create()
    removeExisting()
    local clock = RC_DigitalWatchUI:new(0, 0)
    clock:initialise()
    clock:addToUIManager()
    clock:setVisible(true)
    RC_DigitalWatchUI.instance = clock
end

function RC_DigitalWatchUI.getInstance()
    return RC_DigitalWatchUI.instance
end

local function ensureClock()
    if not RC_DigitalWatchUI.instance then
        RC_DigitalWatchUI.create()
    end
end

local function onResolutionChange()
    if RC_DigitalWatchUI.instance then
        RC_DigitalWatchUI.instance:updateLayout()
    end
end

Events.OnCreateUI.Add(ensureClock)
Events.OnResolutionChange.Add(onResolutionChange)

function RC_DigitalWatchUI.setTimeOverride(value)
    ensureClock()
    if RC_DigitalWatchUI.instance then
        RC_DigitalWatchUI.instance:setTimeOverride(value)
    end
end

function RC_DigitalWatchUI.setTemperatureOverride(value)
    ensureClock()
    if RC_DigitalWatchUI.instance then
        RC_DigitalWatchUI.instance:setTemperatureOverride(value)
    end
end

function RC_DigitalWatchUI.setDateOverride(day, month)
    ensureClock()
    if RC_DigitalWatchUI.instance then
        RC_DigitalWatchUI.instance:setDateOverride(day, month)
    end
end

function RC_DigitalWatchUI.setDigitalOverride(value)
    ensureClock()
    if RC_DigitalWatchUI.instance then
        RC_DigitalWatchUI.instance:setDigitalOverride(value)
    end
end

function RC_DigitalWatchUI.setVisibleOverride(value)
    ensureClock()
    if RC_DigitalWatchUI.instance then
        RC_DigitalWatchUI.instance:setVisibleOverride(value)
    end
end

function RC_DigitalWatchUI.setAlarmSetOverride(value)
    ensureClock()
    if RC_DigitalWatchUI.instance then
        RC_DigitalWatchUI.instance:setAlarmSetOverride(value)
    end
end

function RC_DigitalWatchUI.setAlarmRingingOverride(value)
    ensureClock()
    if RC_DigitalWatchUI.instance then
        RC_DigitalWatchUI.instance:setAlarmRingingOverride(value)
    end
end

return RC_DigitalWatchUI
