----------------
--somewhatfrog--
----------------

local function toggleOptions(option, playerNum)
    local modData = getSpecificPlayer(playerNum):getModData()
    if not modData.SWHEData then
        modData.SWHEData = {}
        modData.SWHEData.HideEquipped = false
    end
    local SWHEData = modData.SWHEData
    if option == "HideEquipped" then
        SWHEData.HideEquipped = not SWHEData.HideEquipped
        local data = ISPlayerData[playerNum+1]
        if not data then return end
        local playerInventory = data.playerInventory
        playerInventory:refreshBackpacks()
    end
end

local function OnFillInventoryObjectContextMenu(playerNum, context, items)
    local modData = getSpecificPlayer(playerNum):getModData()
    if not modData.SWHEData then
        modData.SWHEData = {}
        modData.SWHEData.HideEquipped = false
    end
    local SWHEData = modData.SWHEData
    local option = SWHEData.HideEquipped and getText("ContextMenu_SWHEData_Show") or getText("ContextMenu_SWHEData_Hide")
    context:addOption(option .. " " .. getText("ContextMenu_SWHEData_Equipped"), "HideEquipped", toggleOptions, playerNum)
end
Events.OnFillInventoryObjectContextMenu.Add(OnFillInventoryObjectContextMenu)

local original_ISInventoryPanerefreshContainer = ISInventoryPane.refreshContainer
function ISInventoryPane:refreshContainer()
    original_ISInventoryPanerefreshContainer(self)
    local player = getSpecificPlayer(self.player)
    local modData = player:getModData()
    if not modData.SWHEData then
        modData.SWHEData = {}
        modData.SWHEData.HideEquipped = false
    end
    local SWHEData = modData.SWHEData
    if not SWHEData.HideEquipped then return end
    local primaryHandItem = player:getPrimaryHandItem()
    local secondaryHandItem = player:getSecondaryHandItem()
    local back = player:getClothingItem_Back()
    local equipped = { [primaryHandItem] = true, [secondaryHandItem] = true, [back] = true }
    for i = #self.itemslist, 1, -1 do
        local item = self.itemslist[i]
        local firstItem = item.items[1]
        local holes = firstItem:IsClothing() and firstItem:getHolesNumber() > 0
        local gasMask = firstItem:hasTag("GasMask")
        if item.equipped and not equipped[firstItem] and not holes and not gasMask then table.remove(self.itemslist, i) end
    end
    self:updateScrollbars()
    self.inventory:setDrawDirty(false)
end
