require "DAMN_Parts";

--***********************************************************
--**                   KI5 / bikinihorst                   **
--***********************************************************

DAMN.Parts:processConfigV2("DEF89", {
	["BumperFront"] = {
		partId = "DAMNBumperFront",
		itemToModel = {
			["Base.89defenderBumperFront0"] = "FrontBumper0",
			["Base.89defenderBullbarFrontA"] = "FrontBullbarA",
		},
		default = "trve_random",
		noPartChance = 33,
	},
	["BumperRear110"] = {
		partId = "DAMNBumperRear",
		itemToModel = {
			["Base.89defenderBumperRear0"] = "RearBumper110",
		},
		default = "trve_random",
		noPartChance = 50,
	},
    ["BumperRear130"] = {
		partId = "DAMNBumperRear",
		itemToModel = {
			["Base.89defender130Bumperettes0"] = "RearBumper130",
		},
		default = "trve_random",
		noPartChance = 50,
	},
	["SidestepsShort"] = {
		partId = "DAMNSideSteps",
		itemToModel = {
			["Base.89defenderSidestepsShort2"] = "DEF89step0",
		},
		default = "trve_random",
		noPartChance = 45,
	},
	["SidestepsLong"] = {
		partId = "DAMNSideSteps",
		itemToModel = {
			["Base.89defenderSidestepsLong2"] = "DEF89step1",
		},
		default = "trve_random",
		noPartChance = 45,
	},
	["Mudflaps"] = {
		partId = "DAMNMudflaps",
		itemToModel = {
			["Base.89defenderMudflaps2"] = "DEF89MudflapsFront",
		},
		default = "trve_random",
		noPartChance = 35,
	},
	["TruckBedAddons130"] = {
        partId = "DEF89TruckBedAddon",
        itemToModel = {
            ["Base.89defenderRollbarWithToolbox2"] = "DEF89Rollbar",
            ["Base.89defenderTarpCover2"] = {
                "DEF89TarpCoverLid", "DEF89TarpCover"
            },
            ["Base.89defenderHardCover2"] = {
                "DEF89HardCoverLid", "DEF89HardCover"
            },
        },
        default = "random",
    },
    ["Snorkel"] = {
		partId = "DAMNSnorkel",
		itemToModel = {
			["Base.89defenderSnorkel2"] = "DEF89Snorkel",
		},
		default = "trve_random",
		noPartChance = 50,
	},
	["SpareTire"] = {
		partId = "DAMNSpareTire",
		itemToModel = {
			["Base.89defenderTire2"] = "DEF89SpareTire0",
            ["Base.89defenderDakarTire2"] = "DEF89SpareTire1",
		},
		default = "trve_random",
		noPartChance = 33,
	},
	["SpareTireT"] = {
		partId = "DAMNSpareTire",
		itemToModel = {
			["Base.89defenderTire2"] = "DEF89SpareTireT1",
            ["Base.89defenderDakarTire2"] = "DEF89SpareTireT2",
		},
		default = "trve_random",
		noPartChance = 33,
	},
	["RoofrackM"] = {
		partId = "DEF89Roofrack",
		itemToModel = {
			["Base.89defenderRoofrackM2"] = "DEF89RoofrackM",
		},
	},
	["WindshieldArmor"] = {
		partId = "DAMNWindshieldArmor",
		itemToModel = {
			["Base.89defenderWindshieldArmor"] = "DEF89winda0",
		},
	},
	["WindshieldRearArmor"] = {
		partId = "DAMNWindshieldRearArmor",
		itemToModel = {
			["Base.89defenderWindshieldRearArmor"] = "DEF89windra",
		},
	},
	["FrontLeftArmor"] = {
		partId = "DAMNFrontLeftArmor",
		itemToModel = {
			["Base.89defenderFrontWindowArmor"] = "DEF89leftdoora",
		},
	},
	["FrontRightArmor"] = {
		partId = "DAMNFrontRightArmor",
		itemToModel = {
			["Base.89defenderFrontWindowArmor"] = "DEF89rightdoora",
		},
	},
	["RearLeftArmor"] = {
		partId = "DAMNRearLeftArmor",
		itemToModel = {
			["Base.89defenderRearWindowArmor"] = "DEF89leftdoorra",
		},
	},
	["RearRightArmor"] = {
		partId = "DAMNRearRightArmor",
		itemToModel = {
			["Base.89defenderRearWindowArmor"] = "DEF89rightdoorra",
		},
	},
	["BackLeftArmor"] = {
		partId = "DAMNBackLeftArmor",
		itemToModel = {
			["Base.89defenderBackWindowArmor"] = "DEF89leftwindowba",
		},
	},
	["BackRightArmor"] = {
		partId = "DAMNBackRightArmor",
		itemToModel = {
			["Base.89defenderBackWindowArmor"] = "DEF89rightwindowba",
		},
	},
    ["TireFrontLeft"] = {
		partId = "TireFrontLeft",
		itemToModel = {
            ["Base.89defenderTire2"] = "Tire0",
            ["Base.89defenderDakarTire2"] = "Tire1",
		},
	},
	["TireFrontRight"] = {
		partId = "TireFrontRight",
		itemToModel = {
            ["Base.89defenderTire2"] = "Tire0",
            ["Base.89defenderDakarTire2"] = "Tire1",
		},
	},
	["TireRearLeft"] = {
		partId = "TireRearLeft",
		itemToModel = {
            ["Base.89defenderTire2"] = "Tire0",
            ["Base.89defenderDakarTire2"] = "Tire1",
		},
	},
	["TireRearRight"] = {
		partId = "TireRearRight",
		itemToModel = {
            ["Base.89defenderTire2"] = "Tire0",
            ["Base.89defenderDakarTire2"] = "Tire1",
		},
	},
});

function DEF89.WindshieldVents(player)
    local vehicle = player.getVehicle and player:getVehicle() or nil
    if not vehicle then return end

    if string.find(vehicle:getScriptName(), "89defender") then
        local part = vehicle:getPartById("DEF89Vents")
        local opened = part:getDoor():isOpen()
        local heater = vehicle:getPartById("Heater")
        local modData = heater:getModData()
        local active = modData.active  
        local temperature = tonumber(modData.temperature) or 0

        local coolingON = active and temperature < 0 

        if coolingON and not opened then
            vehicle:playPartAnim(part, "Open")
            vehicle:playPartSound(part, player, "Open")
            part:getDoor():setOpen(true)
            vehicle:transmitPartDoor(part)
        elseif not coolingON and opened then
            vehicle:playPartAnim(part, "Close")
            vehicle:playPartSound(part, player, "Close")
            part:getDoor():setOpen(false) 
            vehicle:transmitPartDoor(part)
        end
    end
end

Events.OnPlayerUpdate.Add(DEF89.WindshieldVents)
