require("StoryItemSpawnerManager.lua")

StoryItemSpawner = StoryItemSpawner or {}

StoryItemSpawner.storyList = StoryItemSpawner.storyList or {}
StoryItemSpawner.spawnSettings = StoryItemSpawner.spawnSettings or {}


local bicyclesInGarages = {
    name = "BicyclesInGarages",
    storyWeightChance = 1,
    items = {
        {itemId = "Bicycle.Bicycle", chance = 80},
    },
    chanceOnFloor = 2,
    chanceOnFurniture = 0,
    furnitureMinOffsetZ = 60, 
    furnitureMaxOffsetZ = 90,
    itemCountPerTileMin = 1,
    itemCountPerTileMax = 1,
    maxStoryCountPerRoom = 1,
    rooms = {
        garagestorage = 0.5,
        garage = 0.5,
        shed = 0.1,
        storage = 0.2,
        basement = 0.2,
        sportstorage = 0.2,
        sportstore = 0.2,
        storageunit = 0.5

    },
    spritesMatch = false,
    sprites = false,
    spritesToIgnore = false,
}


if  getActivatedMods():contains("\\BicycleMod")
    or getActivatedMods():contains("\\BicycleLiteMod") -- lite version
    or getActivatedMods():contains("\\Bicletas") -- brazilian portuguese version
    then
    StoryItemSpawner.storyList[bicyclesInGarages.name] = bicyclesInGarages
end