require("StoryItemSpawnerManager.lua")

StoryItemSpawner = StoryItemSpawner or {}

StoryItemSpawner.storyList = StoryItemSpawner.storyList or {}
StoryItemSpawner.spawnSettings = StoryItemSpawner.spawnSettings or {}


local rideablesInGarages = {
    name = "RideablesInGarages",
    storyWeightChance = 1,
    items = {
        -- filled in later
    },
    chanceOnFloor = 3,
    chanceOnFurniture = 0,
    furnitureMinOffsetZ = 60, 
    furnitureMaxOffsetZ = 90,
    itemCountPerTileMin = 1,
    itemCountPerTileMax = 1,
    maxStoryCountPerRoom = 1,
    rooms = {
        garagestorage = 0.6,
        garage = 0.5,
        shed = 0.1,
        storage = 0.2,
        basement = 0.2,
        sportstorage = 0.2,
        sportstore = 0.2,
        storageunit = 0.5

    },
    spritesMatch = false,
    sprites = false,
    spritesToIgnore = false,
}

local mods = getActivatedMods()
local bicycleModEnabled = mods:contains("\\BicycleMod")  or mods:contains("\\BicycleLiteMod") or mods:contains("\\Bicletas")
local skateboardModEnabled = mods:contains("\\SkateboardMod")
local kickScooterModEnabled = mods:contains("\\KickScooterMod")
local modCount = 0;

if bicycleModEnabled then
    modCount = modCount + 1;
end
if skateboardModEnabled then
    modCount = modCount + 1;
end
if kickScooterModEnabled then
    modCount = modCount + 1;
end

if modCount > 0 then
    if bicycleModEnabled then
        table.insert(rideablesInGarages.items, {itemId = "Bicycle.Bicycle", chance = math.ceil(96*2/(modCount+1))})
    end
    if skateboardModEnabled then
        table.insert(rideablesInGarages.items, {itemId = "Skateboard.Skateboard", chance = math.ceil(96/(modCount+1))})
    end
    if kickScooterModEnabled then
        table.insert(rideablesInGarages.items, {itemId = "KickScooter.KickScooter_Folded", chance = math.ceil(30/(modCount+1))})
        table.insert(rideablesInGarages.items, {itemId = "KickScooter.KickScooter", chance = math.ceil(30/(modCount+1))})
        table.insert(rideablesInGarages.items, {itemId = "KickScooter.KickScooterFlames_Folded", chance = math.ceil(18/(modCount+1))})
        table.insert(rideablesInGarages.items, {itemId = "KickScooter.KickScooterFlames", chance = math.ceil(18/(modCount+1))})
    end
    -- for debug : print(StoryItemSpawner.Dump(StoryItemSpawner.storyList["RideablesInGarages"]))
    StoryItemSpawner.storyList[rideablesInGarages.name] = rideablesInGarages
end