require("SpritesSurfaceDimensions.lua")
require("StoryItemSpawnerManager.lua")


StoryItemSpawner = StoryItemSpawner or {}

StoryItemSpawner.storyList = StoryItemSpawner.storyList or {}
StoryItemSpawner.spawnSettings = StoryItemSpawner.spawnSettings or {}

SpriteDimensions = SpriteDimensions or {}
SpriteDimensions.MiddleSmall = SpriteDimensions.MiddleSmall or {
    minOffsetX = 35,
    maxOffsetX = 65,
    minOffsetY = 35,
    maxOffsetY = 65,
}


local poolTable = {
    name = "poolTable",
    storyWeightChance = 1000,
    itemCountPerTileMin = 2,
    itemCountPerTileMax = 4,
    items = {
        {itemId = "Base.PoolBall", chance = 80},
        {itemId = "Base.Poolcue", chance = 22},
    },
    chanceOnFloor = 0,
    chanceOnFurniture = 90,
    furnitureMinOffsetZ = 10,
    furnitureMaxOffsetZ = 70,
    rooms = false,
    spritesMatch = false,
    maxStoryCountPerRoom = 10,
    sprites = {
        recreational_01_2 = SpriteDimensions.MiddleSmall,
        recreational_01_3 = SpriteDimensions.MiddleSmall,
        recreational_01_6 = SpriteDimensions.MiddleSmall,
        recreational_01_7 = SpriteDimensions.MiddleSmall,
    },
    spritesToIgnore = false
}

StoryItemSpawner.storyList[poolTable.name] = poolTable;