--Rebalanced Yields: Butchering
--Please do not modpack this mod.
--See the Steam Workshop page for more information.
--------------------------------

--function to allow halving cuts of meat that weigh at least 0.4.
function Recipe.OnTest.RYButcheringCutFillet(sourceItem, result)
    if instanceof(sourceItem, "Food") then
        return sourceItem:getActualWeight() > 0.4
    end
    return true
end

--the game can handle halving an item once, but the second time it simply gets duplicated! this should fix it.
--https://theindiestone.com/forums/index.php?/topic/79467-4220-recipeoncreatecutfillet-does-not-work-as-intended/
function Recipe.OnCreate.RYButcheringHalveCutFix(craftRecipeData, character)
    local items = craftRecipeData:getAllConsumedItems()
    local results = craftRecipeData:getAllCreatedItems()
    local meat = nil

    -- find the source meat item
    for i = 0, items:size() - 1 do
        local item = items:get(i)
        if instanceof(item, "Food") then
            meat = item
            break
        end
    end

    if meat then
        -- halve all relevant stats
        local hunger = meat:getBaseHunger() / 2
        local weight = meat:getActualWeight() / 2
        local carbs = meat:getCarbohydrates() / 2
        local lipids = meat:getLipids() / 2
        local proteins = meat:getProteins() / 2
        local calories = meat:getCalories() / 2
        local cooked = meat:isCooked()
        --local rotten = meat:isRotten()
        local age = meat:getAge()
        --local maxAge = meat:getOffAgeMax()

        for j = 0, results:size() - 1 do
            local result = results:get(j)

            -- Basic nutritional values
            result:setBaseHunger(hunger)
            result:setHungChange(hunger)
            result:setActualWeight(weight)
            result:setWeight(weight)
			--custom weight means eating or using item in evolvedrecipe does not decrease weight as more of item is used
            --result:setCustomWeight(true)
            result:setCarbohydrates(carbs)
            result:setLipids(lipids)
            result:setProteins(proteins)
            result:setCalories(calories)

            -- Cooked/Rotten and age state
            result:setCooked(cooked)
            --result:setRotten(rotten)
            result:setAge(age)
            --result:setOffAgeMax(maxAge)

            -- Optional: copy display name or custom name
			--I wanted to keep (Prime Cut) but it duplicates the (Prime Cut) over and over
            --result:setName(meat:getName())
        end
    end
end
