require 'Items/SuburbsDistributions'
require "Items/ProceduralDistributions"
require "Vehicles/VehicleDistributions"

local sandboxVars = SandboxVars.LDO or {}
local DropLD = sandboxVars.DropLD or 1
local DropMLD = sandboxVars.DropMLD or 1

local isOneWeekLater = getActivatedMods():contains("OneWeekLater")
local zombieDropFactor = isOneWeekLater and 0.005 or 0.1

local ItemDist = {
	-- Gris
	{
	Distributions = {
	  {"PoliceLockers", DropLD * 20},
	  {"PoliceStorageGuns", DropLD * 20},
	  {"GarageMetalwork", DropLD * 5},
	  {"ToolStoreBooks", DropLD * 5},
	  {"ArmyHangarMechanics", DropLD * 5},
	  {"FireDeptLockers", DropLD * 5},
	  {"SurvivorCache1", DropLD * 30},
	  {"SurvivorCache2", DropLD * 30},
	  {"SurvivorCache3", DropLD * 30},
	  {"SurvivorCache4", DropLD * 30},
	  {"LootZombies", DropLD * zombieDropFactor}
	},
	Vehicles = {
	  {"PoliceTruckBed", DropLD * 5},
	  {"PoliceSWATTruckBed", DropLD * 5},
	  {"MetalWelderTruckBed", DropLD * 3}
	},
	Items = { "LD.Bag_LegendaryDuffelbag_Grey" }
	},
	-- Rosa
	{
	Distributions = {
	  {"BedroomDresserChild", DropLD * 5},
	  {"BedroomDresser", DropLD * 5},
	  {"BedroomSidetable", DropLD * 5},
	  {"WardrobeWoman", DropLD * 5},
	  {"WardrobeChild", DropLD * 5},
	  {"BandMerchClothes", DropLD * 5},
	  {"BackstageDresser", DropLD * 5},
	  {"LivingRoomSideTable", DropLD * 5},
	  {"SurvivorCache1", DropLD * 30},
	  {"SurvivorCache2", DropLD * 30},
	  {"SurvivorCache3", DropLD * 30},
	  {"SurvivorCache4", DropLD * 30},
	  {"LootZombies", DropLD * zombieDropFactor}
	},
	Vehicles = {
	  {"PostalTruckBed", DropLD * 3},
	  {"BandVanTruckBed", DropLD * 3}
	},
	Items = { "LD.Bag_LegendaryDuffelbag_Pink" }
	},
	-- Negra
	{
	Distributions = {
	  {"BedroomSidetable", DropLD * 5},
	  {"FireDeptLockers", DropLD * 5},
	  {"BedroomDresser", DropLD * 5},
	  {"CrateMetalwork", DropLD * 5},
	  {"CrateRandomJunk", DropLD * 5},
	  {"WardrobeMan", DropLD * 5},
	  {"ArmySurplusMisc", DropLD * 5},
	  {"LivingRoomShelf", DropLD * 5},
	  {"SurvivorCache1", DropLD * 30},
	  {"SurvivorCache2", DropLD * 30},
	  {"SurvivorCache3", DropLD * 30},
	  {"SurvivorCache4", DropLD * 30},
	  {"LootZombies", DropLD * zombieDropFactor}
	},
	Vehicles = {
	  {"MetalWelderTruckBed", DropLD * 5},
	  {"ConstructionTruckBed", DropLD * 5}
	},
	Items = { "LD.Bag_LegendaryDuffelbag_Black" }
	},
	-- Verde
	{
	Distributions = {
	  {"BedroomDresser", DropLD * 5},
	  {"BedroomSidetable", DropLD * 5},
	  {"ArmyStorageOutfit", DropLD * 5},
	  {"ArmySurplusOutfit", DropLD * 5},
	  {"ArmyHangarOutfit", DropLD * 5},
	  {"ArmyBunkerStorage", DropLD * 5},
	  {"WardrobeGeneric", DropLD * 5},
	  {"SurvivorCache1", DropLD * 30},
	  {"SurvivorCache2", DropLD * 30},
	  {"SurvivorCache3", DropLD * 30},
	  {"SurvivorCache4", DropLD * 30},
	  {"LootZombies", DropLD * zombieDropFactor}
	},
	Vehicles = {
	  {"ArmyLightTruckBed", DropLD * 5},
	  {"ArmyHeavyTruckBed", DropLD * 5}
	},
	Items = { "LD.Bag_LegendaryDuffelbag_Green" }
	},
	-- Marrón
	{
	Distributions = {
	  {"BedroomDresser", DropLD * 5},
	  {"BedroomSidetable", DropLD * 5},
	  {"BedroomDresserRedneck", DropLD * 5},
	  {"WardrobeGeneric", DropLD * 5},
	  {"LivingRoomShelfNoTapes", DropLD * 5},
	  {"CrateRandomJunk", DropLD * 5},
	  {"Antiques", DropLD * 5},
	  {"SurvivorCache1", DropLD * 30},
	  {"SurvivorCache2", DropLD * 30},
	  {"SurvivorCache3", DropLD * 30},
	  {"SurvivorCache4", DropLD * 30},
	  {"LootZombies", DropLD * zombieDropFactor}
	},
	Vehicles = {
	  {"PickupTruckBed", DropLD * 3},
	  {"ArmySurplusTruckBed", DropLD * 3}
	},
	Items = { "LD.Bag_LegendaryDuffelbag_Brown" }
	},
	-- Rojo
	{
	  Distributions = {
		{"FireDeptLockers", DropLD * 10},
		{"BedroomDresser", DropLD * 5},
		{"WardrobeMan", DropLD * 5},
		{"CrateTools", DropLD * 5},
		{"SurvivorCache1", DropLD * 30},
		{"SurvivorCache2", DropLD * 30},
		{"SurvivorCache3", DropLD * 30},
		{"SurvivorCache4", DropLD * 30},
		{"LootZombies", DropLD * zombieDropFactor}
	  },
	  Vehicles = {
		{"FireTruckBed", DropLD * 5},
		{"ConstructionTruckBed", DropLD * 3}
	  },
	  Items = { "LD.Bag_LegendaryDuffelbag_Red" }
	},

	-- Azul
	{
	  Distributions = {
		{"PoliceLockers", DropLD * 10},
		{"ToolStoreBooks", DropLD * 5},
		{"GarageMetalwork", DropLD * 5},
		{"CrateMetalwork", DropLD * 5},
		{"SurvivorCache1", DropLD * 30},
		{"SurvivorCache2", DropLD * 30},
		{"SurvivorCache3", DropLD * 30},
		{"SurvivorCache4", DropLD * 30},
		{"LootZombies", DropLD * zombieDropFactor}
	  },
	  Vehicles = {
		{"PoliceTruckBed", DropLD * 5},
		{"MetalWelderTruckBed", DropLD * 3}
	  },
	  Items = { "LD.Bag_LegendaryDuffelbag_Blue" }
	},

	-- Naranja
	{
	  Distributions = {
		{"ConstructionSiteTools", DropLD * 5},
		{"CrateTools", DropLD * 5},
		{"GarageTools", DropLD * 5},
		{"LivingRoomShelf", DropLD * 5},
		{"SurvivorCache1", DropLD * 30},
		{"SurvivorCache2", DropLD * 30},
		{"SurvivorCache3", DropLD * 30},
		{"SurvivorCache4", DropLD * 30},
		{"LootZombies", DropLD * zombieDropFactor}
	  },
	  Vehicles = {
		{"ConstructionTruckBed", DropLD * 5},
		{"PickupTruckBed", DropLD * 3}
	  },
	  Items = { "LD.Bag_LegendaryDuffelbag_Orange" }
	},

	-- Morado
	{
	  Distributions = {
		{"WardrobeWoman", DropLD * 5},
		{"BedroomDresser", DropLD * 5},
		{"BandMerchClothes", DropLD * 5},
		{"LivingRoomSideTable", DropLD * 5},
		{"BackstageDresser", DropLD * 5},
		{"SurvivorCache1", DropLD * 30},
		{"SurvivorCache2", DropLD * 30},
		{"SurvivorCache3", DropLD * 30},
		{"SurvivorCache4", DropLD * 30},
		{"LootZombies", DropLD * zombieDropFactor}
	  },
	  Vehicles = {
		{"BandVanTruckBed", DropLD * 3},
		{"PostalTruckBed", DropLD * 3}
	  },
	  Items = { "LD.Bag_LegendaryDuffelbag_Purple" }
	},

	-- Blanco
	{
	  Distributions = {
		{"WardrobeGeneric", DropLD * 5},
		{"BedroomDresser", DropLD * 5},
		{"LivingRoomShelf", DropLD * 5},
		{"ToolStoreBooks", DropLD * 5},
		{"SurvivorCache1", DropLD * 30},
		{"SurvivorCache2", DropLD * 30},
		{"SurvivorCache3", DropLD * 30},
		{"SurvivorCache4", DropLD * 30},
		{"LootZombies", DropLD * zombieDropFactor}
	  },
	  Vehicles = {
		{"PostalTruckBed", DropLD * 3},
		{"ArmySurplusTruckBed", DropLD * 3}
	  },
	  Items = { "LD.Bag_LegendaryDuffelbag_White" }
	},  
  -- Revista
  {
    Distributions = {
      {"ShelfGeneric", DropMLD * 15},
      {"postbox", DropMLD * 15},
      {"BedroomSidetable", DropMLD * 5},
      {"BedroomDresser", DropMLD * 5},
      {"LivingRoomShelf", DropMLD * 5},
      {"LibraryBooks", DropMLD * 30},
      {"CrateMagazines", DropMLD * 30},
      {"BookstoreMisc", DropMLD * 20},
      {"MagazineRackMixed", DropMLD * 20},
      {"PostOfficeMagazines", DropMLD * 20},
      {"ToolStoreBooks", DropMLD * 20},
      {"LivingRoomSideTable", DropMLD * 20},
      {"LivingRoomSideTableNoRemote", DropMLD * 20},
      {"GarageMetalwork", DropMLD * 20},
      {"SafehouseKitchen", DropMLD * 20},
      {"SurvivorCache1", DropMLD * 30},
      {"SurvivorCache2", DropMLD * 30},
      {"SurvivorCache3", DropMLD * 30},
      {"SurvivorCache4", DropMLD * 30},
      {"LootZombies", DropMLD * (zombieDropFactor * 2)}
    },
    Vehicles = {
      {"PoliceTruckBed", DropMLD * 5},
      {"ArmyLightTruckBed", DropMLD * 5},
      {"MetalWelderTruckBed", DropMLD * 5}
    },
    Items = { "LD.LDMagLegendary" }
  }
}

local function getLootTable(name)
  return ProceduralDistributions.list[name] or (SuburbsDistributions["all"] and SuburbsDistributions["all"][name])
end

local function insertItem(tLootTable, item, weight)
  if tLootTable then
    table.insert(tLootTable.items, item)
    table.insert(tLootTable.items, weight)
  end
end

local function insertVehicleItem(vehicleTable, item, weight)
  if vehicleTable then
    table.insert(vehicleTable.items, item)
    table.insert(vehicleTable.items, weight)
  end
end

local function preDistributionMerge()
  for _, group in ipairs(ItemDist) do
    if group.Distributions then
      for _, dist in ipairs(group.Distributions) do
        local lootTable = getLootTable(dist[1])
        for _, item in ipairs(group.Items) do
          insertItem(lootTable, item, dist[2])
        end
      end
    end
    if group.Vehicles then
      for _, veh in ipairs(group.Vehicles) do
        local vehicleTable = VehicleDistributions[veh[1]]
        for _, item in ipairs(group.Items) do
          insertVehicleItem(vehicleTable, item, veh[2])
        end
      end
    end
  end
end

Events.OnPreDistributionMerge.Add(preDistributionMerge)