-- From "Stairs East&South [B42]" mod -- Author = carlesturo

-- ------------------------------------------------------------------------------------------------

-- **************** STAIRS EAST&SOUTH - RECIPE CODE ****************

SES_BuildRecipeCode = SES_BuildRecipeCode or {}
SES_BuildRecipeCode.stairs = {}

local facingPartsMap = {
    ["s"] = {"top", "middle", "bottom"}, -- West
    ["w"] = {"top", "middle", "bottom"}, -- North
    ["n"] = {"bottom", "middle", "top"}, -- East
    ["e"] = {"bottom", "middle", "top"}, -- South
}

local spriteIndexOnIsValid = 1

local function resetAndReturnOnIsValid(value, partsOrder)
	if spriteIndexOnIsValid > #partsOrder then
		spriteIndexOnIsValid = 1
	end
    return value
end

local function hasStairsAt(square) -- Cannot build where there are stairs.
	if not square then return false end
	for i = 0, square:getObjects():size() - 1 do
		local obj = square:getObjects():get(i)
		local sprite = obj:getSprite()
		if sprite then
			local tileType = sprite:getType()
			if tileType == IsoObjectType.stairsTN or tileType == IsoObjectType.stairsMN or tileType == IsoObjectType.stairsBN or
			   tileType == IsoObjectType.stairsTW or tileType == IsoObjectType.stairsMW or tileType == IsoObjectType.stairsBW then
				return true
			end

			local spriteName = sprite:getName()
			if (sprite:getProperties() and sprite:getProperties():Val("CustomName") == "Stairs") or (spriteName and string.find(string.lower(spriteName), "stairs")) then
				return true
			end
		end
	end
	return false
end

function SES_BuildRecipeCode.stairs.OnIsValid(params)
    local facing = params.facing
    local partsOrder = facingPartsMap[facing]
    local part = partsOrder[spriteIndexOnIsValid]

	spriteIndexOnIsValid = spriteIndexOnIsValid + 1

	--local isTopStair = (part == "top")
	--local isMiddleStair = (part == "middle")
	local isBottomStair = (part == "bottom")

	local x, y, z = params.square:getX(), params.square:getY(), params.square:getZ()

	if params.square:getZ() >= getMaximumWorldLevel() then
		return resetAndReturnOnIsValid(false, partsOrder)
	end

	--if params.square:getModData()["ConnectedToStairs" .. tostring(not (facing == "w"))] then
		--return resetAndReturnOnIsValid(false, partsOrder)
	--end

    local belowSquare = getCell():getGridSquare(x, y, z - 1)
    local aboveSquare = getCell():getGridSquare(x, y, z + 1)

    if hasStairsAt(params.square) or hasStairsAt(belowSquare) or hasStairsAt(aboveSquare) then
        return resetAndReturnOnIsValid(false, partsOrder)
    end

	-- Don't allow walls and obstacles at the parts of stairs.
	if params.square then
		if (facing == "w" or facing == "e") and (params.square:getProperties():Is("WallN") or params.square:getProperties():Is(IsoFlagType.collideN)) then -- (TopNorth) (BottomSouth) (z=0)
			return resetAndReturnOnIsValid(false, partsOrder)
		end
		if (facing == "s" or facing == "n") and (params.square:getProperties():Is("WallW") or params.square:getProperties():Is(IsoFlagType.collideW)) then -- (TopWest) (BottomEast) (z=0)
			return resetAndReturnOnIsValid(false, partsOrder)
		end

		local dx, dy, dz = params.square:getX(), params.square:getY(), params.square:getZ();
		if (facing == "w") then -- North
			dy = dy + 1
		elseif (facing == "s") then -- West
			dx = dx + 1
		elseif (facing == "e") then -- South
			dy = dy + 1
		elseif (facing == "n") then -- East
			dx = dx + 1
		end
		local backWall = getCell():getGridSquare(dx, dy, dz)
		if backWall then
			for i = 0, backWall:getObjects():size() - 1 do
				local obj = backWall:getObjects():get(i)
				local props = obj:getProperties()
				if props then
					if (facing == "w" or facing == "e") and (props:Is("WallN") or props:Is(IsoFlagType.collideN)) then -- (BottomNorth) (TopSouth) (z=0)
						return resetAndReturnOnIsValid(false, partsOrder)
					end
					if (facing == "s" or facing == "n") and (props:Is("WallW") or props:Is(IsoFlagType.collideW)) then -- (BottomWest) (TopEast) (z=0)
						return resetAndReturnOnIsValid(false, partsOrder)
					end
				end
			end
		end

		-- Top/Middle/Bottom
		local tileInfoSpriteProps = tileInfoSprite and tileInfoSprite:getProperties()
		if (params.square:getProperties() and params.square:getProperties():Is("BlocksPlacement"))
		   or params.square:isSolid()
		   or params.square:isSolidTrans()
		   or (tileInfoSpriteProps and (tileInfoSpriteProps:Is(IsoFlagType.solidtrans) or tileInfoSpriteProps:Is("BlocksPlacement")))
		   or (tileInfoSpriteProps and tileInfoSpriteProps:Is(IsoFlagType.canBeRemoved)) then
			return resetAndReturnOnIsValid(false, partsOrder)
		end

		if params.square:isVehicleIntersecting() then
			return resetAndReturnOnIsValid(false, partsOrder)
		end
	end

	-- Check for floors above the stairs.
	local above = getCell():getGridSquare(x, y, z + 1)
	if above and above:getFloor() then
		return resetAndReturnOnIsValid(false, partsOrder)
	end

	-- canBuildOverWater true for mid and top stair
	if params.square:getZ() == 0 then
		local overWater = params.square:getFloor() and (params.square:getFloor():getSprite():getProperties():Is(IsoFlagType.water) or params.square:getFloor():getSprite():getProperties():Is(IsoFlagType.taintedWater))
		if isBottomStair and overWater then
			return resetAndReturnOnIsValid(false, partsOrder)
		end
	end

	-- do top stair checks
	-- Don't allow walls at the top of stairs.
	if above then
		if facing == "w" and (above:getProperties():Is("WallN") or above:getProperties():Is(IsoFlagType.collideN)) then -- (TopNorth) (z=1)
			return resetAndReturnOnIsValid(false, partsOrder)
		end
		if facing == "s" and (above:getProperties():Is("WallW") or above:getProperties():Is(IsoFlagType.collideW)) then -- (TopWest) (z=1)
			return resetAndReturnOnIsValid(false, partsOrder)
		end
	end

	-- Don't allow walls (back walls) and obstacles at the top of stairs.
	local xt, yt, zt = params.square:getX(), params.square:getY(), params.square:getZ()+1;
	if (facing == "w") then -- North
		yt = yt - 1
	elseif (facing == "s") then -- West
		xt = xt - 1
	elseif (facing == "e") then -- South
		yt = yt + 1
	elseif (facing == "n") then -- East
		xt = xt + 1
	end
	local top = getCell():getGridSquare(xt, yt, zt)
	if top then
		if (top:isSolid() or top:isSolidTrans()) then -- North/West/South/East (z=1)
			return resetAndReturnOnIsValid(false, partsOrder)
		end

		for i = 0, top:getObjects():size() - 1 do
			local obj = top:getObjects():get(i)
			local props = obj:getProperties()
			if props then
				if (facing == "e") and (props:Is("WallN") or props:Is(IsoFlagType.collideN)) then -- (TopSouth) (z=1)
					return resetAndReturnOnIsValid(false, partsOrder)
				end
				if (facing == "n") and (props:Is("WallW") or props:Is(IsoFlagType.collideW)) then -- (TopEast) (z=1)
					return resetAndReturnOnIsValid(false, partsOrder)
				end
			end
		end
	end

	return resetAndReturnOnIsValid(true, partsOrder)
end

local myStairsToReplace = {}

local tickCounter = 0
local tickRate = 10

local function removeAndAddStairs() -- Remove and re-add the stairs to restore horizontal movement between stairs, lost when using the recipe.
    tickCounter = tickCounter + 1
    if tickCounter < tickRate then return end
    tickCounter = 0

    if #myStairsToReplace == 0 then
        Events.OnTick.Remove(removeAndAddStairs)
        return
    end

    for _, obj in ipairs(myStairsToReplace) do
        local sq = obj:getSquare()
        if sq then
            local oldSprite = obj:getSprite()
            local x, y, z = obj:getX(), obj:getY(), obj:getZ()

            sq:transmitRemoveItemFromSquare(obj)

            local newObj = IsoObject.new(getCell(), sq, oldSprite)
            sq:AddTileObject(newObj)
            newObj:transmitCompleteItemToServer()
        end
    end

    myStairsToReplace = {}
    Events.OnTick.Remove(removeAndAddStairs)
end

local spriteIndexOnCreate = 1

function SES_BuildRecipeCode.stairs.OnCreate(params)
    local thumpable = params.thumpable;
    local facing = params.facing
    local partsOrder = facingPartsMap[facing]
    local part = partsOrder[spriteIndexOnCreate]

	spriteIndexOnCreate = spriteIndexOnCreate + 1

	table.insert(myStairsToReplace, thumpable)

	local topNorth = (part == "top") and (facing == "w")
	local topWest = (part == "top") and (facing == "s")
	local topSouth = (part == "top") and (facing == "e")
	local topEast = (part == "top") and (facing == "n")
	local middleStair = (part == "middle")

	local x = thumpable:getX();
	local y = thumpable:getY();
	local z = thumpable:getZ();

	local square = thumpable:getSquare();
	local overWater = (square:getFloor() ~= nil) and square:getFloor():getSprite():getProperties():Is(IsoFlagType.water);

	-- remove removable objects
	local objects = square:getObjects();
	for i=objects:size()-1, 0, -1 do
		local object = objects:get(i);
		if object and object ~= thumpable then
			local objProps = object:getProperties();

			local shouldRemove = objProps and ((object:getProperties():Is(IsoFlagType.vegitation) and object:getType() ~= IsoObjectType.tree) or object:getProperties():Is(IsoFlagType.canBeRemoved));
			overWater = overWater or object:getSprite():getProperties():Is(IsoFlagType.water) or object:getSprite():getProperties():Is(IsoFlagType.taintedWater);

			if object:getTextureName() ~= nil and string.contains(object:getTextureName(), "floors_rugs") then
				shouldRemove = false;
			end

			if shouldRemove then
				square:transmitRemoveItemFromSquare(object)
				square:RemoveTileObject(object);
			end
		end
	end

	-- get desired floor tile
	local floorTile = "carpentry_02_57";
	if thumpable:getTextureName() and string.contains(thumpable:getTextureName(), "constructedobjects") then
		floorTile = "constructedobjects_01_86";
	end

	-- place floor under stair if on water -- DOESN'T WORK
	--[[if z == 0 and overWater then
		square:addFloor(floorTile);
	end--]]

	-- add landing
	if topNorth or topWest or topSouth or topEast then
		local above = nil

		if topNorth then
			if getWorld():isValidSquare(x, y-1, z+1) then
				above = getCell():getGridSquare(x, y-1, z+1);
				if above == nil then
					above = IsoGridSquare.new(getCell(), nil, x, y-1, z+1);
					getCell():ConnectNewSquare(above, false);
				end

				if not above:getProperties():Is(IsoFlagType.solidfloor) then
					above:addFloor(floorTile);
				end
			end
		elseif topWest then
			if getWorld():isValidSquare(x-1, y, z+1) then
				above = getCell():getGridSquare(x-1, y, z+1);
				if above == nil then
					above = IsoGridSquare.new(getCell(), nil, x-1, y, z+1);
					getCell():ConnectNewSquare(above, false);
				end
				if not above:getProperties():Is(IsoFlagType.solidfloor) then
					above:addFloor(floorTile);
				end
			end
		elseif topSouth then
			if getWorld():isValidSquare(x, y+1, z+1) then
				above = getCell():getGridSquare(x, y+1, z+1);
				if above == nil then
					above = IsoGridSquare.new(getCell(), nil, x, y+1, z+1);
					getCell():ConnectNewSquare(above, false);
				end
				if not above:getProperties():Is(IsoFlagType.solidfloor) then
					above:addFloor(floorTile);
				end
			end
		elseif topEast then
			if getWorld():isValidSquare(x+1, y, z+1) then
				above = getCell():getGridSquare(x+1, y, z+1);
				if above == nil then
					above = IsoGridSquare.new(getCell(), nil, x+1, y, z+1);
					getCell():ConnectNewSquare(above, false);
				end
				if not above:getProperties():Is(IsoFlagType.solidfloor) then
					above:addFloor(floorTile);
				end
			end
		end

		--above:getModData()["ConnectedToStairs"..tostring(topNorth)] = true;
		--above:RecalcAllWithNeighbours(true);

		above = getCell():getGridSquare(x, y, z+1);
		if above == nil then
			above = IsoGridSquare.new(getCell(), nil, x, y, z+1);
			getCell():ConnectNewSquare(above, false);
		end
		above:RecalcAllWithNeighbours(true);
	end

	-- add pillars

    if spriteIndexOnCreate > #partsOrder then
        spriteIndexOnCreate = 1

        Events.OnTick.Add(removeAndAddStairs)
    end
end

-- ------------------------------------------------------------------------------------------------