-- From "Stairs East&South [B42]" mod -- Author = carlesturo

-- ------------------------------------------------------------------------------------------------

-- **************** STAIRS EAST&SOUTH - FLOOR FLIP ****************

local FloorFlip = {
    ["SES_floors_01_1"]  = "SES_floors_01_129",
    ["SES_floors_01_129"] = "SES_floors_01_1",

    ["SES_floors_01_10"]  = "SES_floors_01_138",
    ["SES_floors_01_138"] = "SES_floors_01_10",

    ["SES_floors_01_19"]  = "SES_floors_01_147",
    ["SES_floors_01_147"] = "SES_floors_01_19",

    ["SES_floors_01_28"] = "SES_floors_01_156",
    ["SES_floors_01_156"] = "SES_floors_01_28",

    ["SES_floors_01_41"] = "SES_floors_01_169",
    ["SES_floors_01_169"] = "SES_floors_01_41",

    ["SES_floors_01_50"] = "SES_floors_01_178",
    ["SES_floors_01_178"] = "SES_floors_01_50",

    ["SES_floors_01_59"] = "SES_floors_01_187",
    ["SES_floors_01_187"] = "SES_floors_01_59",

    ["SES_floors_01_68"] = "SES_floors_01_196",
    ["SES_floors_01_196"] = "SES_floors_01_68",

    ["SES_floors_01_81"] = "SES_floors_01_209",
    ["SES_floors_01_209"] = "SES_floors_01_81",

    ["SES_floors_01_90"] = "SES_floors_01_218",
    ["SES_floors_01_218"] = "SES_floors_01_90",

    ["SES_floors_01_99"] = "SES_floors_01_227",
    ["SES_floors_01_227"] = "SES_floors_01_99",

    ["SES_floors_01_108"] = "SES_floors_01_236",
    ["SES_floors_01_236"] = "SES_floors_01_108",
}

-- ------------------------------------------------------------------------------------------------

local function flipTileObjectIfNeeded(square)
    local objects = square:getObjects()
    local changed = false
    for i = 0, objects:size() - 1 do
        local obj = objects:get(i)
        local spr = obj and obj:getSprite()
        local name = spr and spr:getName()
        local newName = name and FloorFlip[name] or nil
        if newName then
            obj:setSpriteFromName(newName)
            obj:transmitUpdatedSpriteToServer()
            changed = true
        end
    end

    if changed then square:RecalcAllWithNeighbours(true) end
    return changed
end

-- ------------------------------------------------------------------------------------------------

local tickCounter = 0
local tickRate = 10
local radius = 1
local isInVehicle = false

local function OnTick()
	if not SES.options.flipTile:getValue() or isInVehicle then return end

    tickCounter = tickCounter + 1
    if tickCounter < tickRate then return end
    tickCounter = 0

	for p = 0, getNumActivePlayers() - 1 do
		local player = getSpecificPlayer(p)
		if player then
			local sq = player:getSquare()
			if sq then
				local x, y, z = sq:getX(), sq:getY(), sq:getZ()
				for dx = -radius, radius do
					for dy = -radius, radius do
						local nsq = getCell():getGridSquare(x + dx, y + dy, z)
						if nsq then
							flipTileObjectIfNeeded(nsq)
						end
					end
				end
			end
		end
	end
end

Events.OnTick.Add(OnTick)

local function OnCreatePlayer(index, player)
    isInVehicle = player:getVehicle() and true or false
end
Events.OnCreatePlayer.Add(OnCreatePlayer)

local function OnEnterVehicle(character)
    isInVehicle = true
end
Events.OnEnterVehicle.Add(OnEnterVehicle)

local function OnExitVehicle(character)
    isInVehicle = false
end
Events.OnExitVehicle.Add(OnExitVehicle)

-- ------------------------------------------------------------------------------------------------