-- Computer_Persist_Ext.lua
-- Extends ComputerPersist to capture the entire computerData table, so new fields (new fields) persist when moving.

require "Computer/Computer_Persist"

local function deepcopy(v, seen)
  if type(v) ~= "table" then return v end
  seen = seen or {}
  if seen[v] then return seen[v] end
  local t = {}
  seen[v] = t
  for k, val in pairs(v) do t[deepcopy(k, seen)] = deepcopy(val, seen) end
  return t
end

local function genId()
  local z = (ZombRand and ZombRand(2147483647) or math.random(2147483647))
  local t = os.time and os.time() or 0
  return tostring(t) .. "-" .. tostring(z)
end

-- Override capture to copy all computerData (backward-compatible)
ComputerPersist.captureStateFromObject = function(obj)
  if not obj or not obj.getModData then return nil end
  local md = obj:getModData()
  local cd = md.computerData or {}
  local state = {
    computerData  = deepcopy(cd),
    Computer_On   = false,
    Computer_UUID = md.Computer_UUID or genId(),
  }
  return state
end
