-- ISComputerPanel_TabsLogic.lua (respect "Cancel" on Play button while a game/action is running)

local function _normKeyFromTabs(self)
    local idx = self._activeTab or 1
    local title = (self._tabs and self._tabs[idx]) or "Games"
    title = tostring(title):gsub(":%s*$","")
    if title == "" then title = "Games" end
    return title
end

local _TITLE_MAP = {
    Games = { install = "Install",  uninst = "Uninstall", play = "Play" },
    Apps  = { install = "Install",  uninst = "Uninstall", play = "Run"  },
    Docs  = { install = "Copy",     uninst = "Delete",    play = "Read" },
    Audio = { install = "Copy",     uninst = "Delete",    play = "Play" },
    Video = { install = "Copy",     uninst = "Delete",    play = "Play" },
}

local function _getBtnTitle(btn)
    if not btn then return nil end
    if btn.getTitle then
        local ok, t = pcall(function() return btn:getTitle() end)
        if ok and t then return t end
    end
    return btn.title
end

local function _setButtonTitles(self, key)
    local map = _TITLE_MAP[key or _normKeyFromTabs(self)] or _TITLE_MAP.Games

    -- >>> COMP:InstallCancelGuard >>>
    if self.btnInstall and self.btnInstall.setTitle then
        -- Не перетирать \"Cancel\", выставленный базовой логикой во время установки
        local curI = self.btnInstall and (self.btnInstall.title or (self.btnInstall.getTitle and self.btnInstall:getTitle()))
        local isCancelI = curI and tostring(curI):lower() == "cancel"
        if not isCancelI then
            self.btnInstall:setTitle(map.install)
        end
    end
    -- <<< COMP:InstallCancelGuard <<<
    if self.btnUninstall and self.btnUninstall.setTitle then
        self.btnUninstall:setTitle(map.uninst)
    end
    if self.btnUninst and self.btnUninst.setTitle then
        self.btnUninst:setTitle(map.uninst)
    end

    -- Don't stomp over "Cancel" that base/game logic may have set while running.
    local cur = _getBtnTitle(self.btnPlay)
    local isCancel = cur and tostring(cur):lower() == "cancel"
    if self.btnPlay and self.btnPlay.setTitle and (not isCancel) then
        self.btnPlay:setTitle(map.play)
    end
end

local _orig_setActiveTab = ISComputerPanel.setActiveTab
function ISComputerPanel:setActiveTab(tab)
    if _orig_setActiveTab then _orig_setActiveTab(self, tab) end
    _setButtonTitles(self, _normKeyFromTabs(self))
    if self.refreshList then self:refreshList() end
    if self.updateButtons then self:updateButtons() end
end

local _orig_updateButtons = ISComputerPanel.updateButtons
function ISComputerPanel:updateButtons()
    if _orig_updateButtons then _orig_updateButtons(self) end
    _setButtonTitles(self, _normKeyFromTabs(self))
end

local _orig_refreshList = ISComputerPanel.refreshList
function ISComputerPanel:refreshList()
    local key = _normKeyFromTabs(self)
    local prev = self.installed
    if self._tabData and self._tabData[key] then
        self.installed = self._tabData[key]
    end
    if _orig_refreshList then _orig_refreshList(self) end
    self.installed = prev
end
