
function ISComputerPanel:prerender()
  ISPanel.prerender(self)

  local p = self:hasPower()
  if self._lastPower ~= p then
    self._lastPower = p
    if not p and self.isOn then self:forcePowerOff() end
    ComputerLight.refresh(self.worldObj)
    self:updateButtons()
  end
  if self._lastSelected ~= self.list.selected then
    self._lastSelected = self.list.selected
    self:updateButtons()
  end

  -- sync cdOpen from modData (tray completion)
  local md2 = self.worldObj and self.worldObj.getModData and self.worldObj:getModData() or nil
  if md2 and md2.computerData and md2.computerData.cdOpen ~= nil then
    local mdOpen = md2.computerData.cdOpen and true or false
    if self.cdOpen ~= mdOpen then
      self.cdOpen = mdOpen
      ComputerLight.refresh(self.worldObj)
      self:updateButtons()
    end
  end

  -- title bar
  self:drawRect(0, 0, self.width, self.titlebarH, 1, 0.15, 0.15, 0.15)
  local tm = getTextManager()
  local tw = tm:MeasureStringX(UIFont.Small, self.title)
  local th = tm:getFontHeight(UIFont.Small)
  local tx = math.floor((self.width - tw) / 2)
  local ty = math.floor((self.titlebarH - th) / 2)
  self:drawText(self.title, tx, ty, 1, 1, 1, 1, UIFont.Small)

  -- draw tab bar border line under header area
  do
    local rx = self._layout.rightX
    local ry = self._layout.rightY + self._layout.rightHeaderH - 1
    local rw = self._layout.rightW
    self:drawRect(rx, ry, rw, 1, 1, 0.6, 0.6, 0.6)
  end

  self:drawRectBorder(0, 0, self.width, self.height, 1, 0.15, 0.15, 0.15)
end


function ISComputerPanel:render()
  ISPanel.render(self)

  local powered = (self.isOn and self:hasPower()) and true or false

  -- memory capacity (games installed / cap)
  local capMax = (ComputerData and ComputerData.MAX_GAMES) and ComputerData.MAX_GAMES or 20
  local capCnt = 0
  if ComputerData and ComputerData.countInstalled then
    capCnt = ComputerData.countInstalled(self.worldObj) or 0
  elseif self.list and self.list.items then
    capCnt = #self.list.items
  end
  if capCnt < 0 then capCnt = 0 end
  if capCnt > capMax then capCnt = capMax end
  local ratio = (capMax > 0) and (capCnt / capMax) or 0

  local tm = getTextManager()
  local font = UIFont.Small

  -- border and fill colors
  local borderOnR, borderOnG, borderOnB, borderOnA = 0.6, 0.6, 0.6, 1.0
  -- disabled buttons in ISButton use red-ish border (0.7, 0.1, 0.1, 0.7)
  local borderOffR, borderOffG, borderOffB, borderOffA = 0.7, 0.1, 0.1, 0.7
  local fillOnR, fillOnG, fillOnB = 0.35, 0.75, 0.35
  local fillOffR, fillOffG, fillOffB = 0.3, 0.3, 0.3

  -- Right list frame + geometry clamp aligned with MEMORY bar
  do
    local rx = self._layout.rightX
    local ry = self._layout.rightY + self._layout.rightHeaderH
    local rw = self._layout.rightW
    local baselineBottom
    if self._ui and self._ui.memory then
      baselineBottom = self._ui.memory.y + self._ui.memory.h
    else
      baselineBottom = self._layout.rightY + self._layout.rightH
    end
    local rh = baselineBottom - ry
    if rh < 0 then rh = 0 end
    local bottomPad = 8
    if self.list then
      if self.list.x ~= rx or self.list.y ~= ry or self.list.width ~= rw or self.list.height ~= (rh - bottomPad) then
        self.list:setX(rx); self.list:setY(ry); self.list:setWidth(rw); self.list:setHeight(math.max(0, rh - bottomPad))
      end
    end
    local powered2 = (self.isOn and self:hasPower()) and true or false
    local bR = powered2 and borderOnR or borderOffR
    local bG = powered2 and borderOnG or borderOffG
    local bB = powered2 and borderOnB or borderOffB
    local bA = powered2 and borderOnA or borderOffA
    self:drawRectBorder(rx, ry, rw, rh, bA, bR, bG, bB)
  end

  -- STATUS bar (on top)
  do
    local r = self._ui and self._ui.status or nil
    if r then
      local job = powered and ComputerJobs.getJob(self.worldObj) or nil
      local isActive = job and job.type ~= "tray"
      local playing = (self.activeActionType == "play")
      local busy = (isActive or playing)
      local progress = isActive and (ComputerJobs.getProgress(self.worldObj) or 0.0) or 0.0

      local fillW = 0
      local showIdle = false
      local baseWord = nil
      local dots = ""

      if powered then
        if busy then
          local ms = (UIManager and UIManager.getMillisSinceLastRender and UIManager.getMillisSinceLastRender()) or 0
          self._dotT = (self._dotT or 0) + ms
          if self._dotT > 300 then
            self._dotT = self._dotT % 300
            self._dotN = ((self._dotN or 0) + 1) % 4
          end
          local n = self._dotN or 0
          if n == 1 then dots = "." elseif n == 2 then dots = ".." elseif n == 3 then dots = "..." else dots = "" end

          if isActive then fillW = math.floor(r.w * progress) end
          baseWord = (isActive and ((job.type == "install") and "Installing" or "Uninstalling")) or (playing and "Playing" or nil)
        else
          showIdle = true
        end
      end

      if fillW > 0 then
        self:drawRect(r.x, r.y, fillW, r.h, 1, fillOnR, fillOnG, fillOnB)
      end
      local bR = powered and borderOnR or borderOffR
      local bG = powered and borderOnG or borderOffG
      local bB = powered and borderOnB or borderOffB
      local bA = powered and borderOnA or borderOffA
      self:drawRectBorder(r.x, r.y, r.w, r.h, bA, bR, bG, bB)

      if powered then
        if showIdle then
          local txt = "Idle"
          local tw = tm:MeasureStringX(font, txt)
          local th = tm:getFontHeight(font)
          local tx = r.x + math.floor((r.w - tw)/2)
          local ty = r.y + math.floor((r.h - th)/2)
          self:drawText(txt, tx, ty, 1, 1, 1, 1, font)
        elseif baseWord then
          local baseW = tm:MeasureStringX(font, baseWord)
          local baseH = tm:getFontHeight(font)
          local baseX = r.x + math.floor((r.w - baseW)/2)
          local baseY = r.y + math.floor((r.h - baseH)/2)
          self:drawText(baseWord, baseX, baseY, 1, 1, 1, 1, font)
          if dots ~= "" then
            local dotsX = baseX + baseW
            self:drawText(dots, dotsX, baseY, 1, 1, 1, 1, font)
          end
        end
      end
    end
  end

  -- MEMORY bar (bottom)
  do
    local r = self._ui and self._ui.memory or nil
    if r then
      local fillW = math.floor(r.w * ratio)
      if fillW > 0 then
        local rr = powered and fillOnR or fillOffR
        local gg = powered and fillOnG or fillOffG
        local bb = powered and fillOnB or fillOffB
        self:drawRect(r.x, r.y, fillW, r.h, 1, rr, gg, bb)
      end
      local bR = powered and borderOnR or borderOffR
      local bG = powered and borderOnG or borderOffG
      local bB = powered and borderOnB or borderOffB
      local bA = powered and borderOnA or borderOffA
      self:drawRectBorder(r.x, r.y, r.w, r.h, bA, bR, bG, bB)
    end
  end

  -- refresh list+buttons when a job just finished
  local jobNow = ComputerJobs.getJob(self.worldObj)
  local hadJob = self._hadJob
  local hasJob = (jobNow ~= nil)
  if hadJob and (not hasJob) then
    local key = self._tabKeys[self._activeTab or 1]
    if key == "games" then
      ComputerData.populateListUI(self.worldObj, self.list)
    else
      ComputerData.populateListUIByKey(self.worldObj, self.list, key)
    end
    ComputerLight.refresh(self.worldObj)
    self:updateButtons()
  end
  self._hadJob = hasJob
end


function ISComputerPanel:onMouseUpOutside(x, y) end


function ISComputerPanel:onClose()
  local job = ComputerJobs.getJob(self.worldObj)
  if job and job.type == "uninstall" then return end
  self:removeFromUIManager()
  if ComputerMod and ComputerMod.windows then
    ComputerMod.windows[self.playerIndex] = nil
  end
end
