function ISComputerPanel:hasPower()
  local obj = self.worldObj
  if not obj or not obj.getSquare then return false end
  local sq = obj:getSquare()
  if not sq then return false end

  local hydro = false
  if getWorld and getWorld().isHydroPowerOn then
    hydro = getWorld():isHydroPowerOn() and true or false
  end

  local sqElec = false
  if sq.haveElectricity then
    local ok = sq:haveElectricity()
    sqElec = (ok == true)
  end

  local genOk = false
  if sq.getGenerator then
    local gen = sq:getGenerator()
    if gen and gen.isActivated and gen:isActivated()
      and gen.isConnected and gen:isConnected()
      and gen.getFuel and gen:getFuel() > 0 then
      genOk = true
    end
  end

  return hydro or sqElec or genOk
end

-- 3D sound helper (from computer, fallback player)


function ISComputerPanel:forcePowerOff()
  if not self.isOn then
    if self.closeBtn and self.closeBtn.setEnable then self.closeBtn:setEnable(true) end
    return
  end
  self.isOn = false
  if ComputerMod and ComputerMod.setComputerOn then
    ComputerMod.setComputerOn(self.worldObj, false)
  else
    local md = self.worldObj and self.worldObj:getModData() or nil
    if md then
      md.Computer_On = false
      if self.worldObj.transmitModData then self.worldObj:transmitModData() end
    end
  end
  self:updateButtons()
end
